-- MySQL dump 10.13  Distrib 8.4.4, for macos15 (arm64)
--
-- Host: 127.0.0.1    Database: botble
-- ------------------------------------------------------
-- Server version	8.4.4

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'sdaf6uVl37ruxzMnq13DqFFlEFpmhdV9',1,'2025-10-22 06:36:17','2025-10-22 06:36:17','2025-10-22 06:36:17');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blocks`
--

DROP TABLE IF EXISTS `blocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `blocks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `raw_content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `blocks_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blocks`
--

LOCK TABLES `blocks` WRITE;
/*!40000 ALTER TABLE `blocks` DISABLE KEYS */;
INSERT INTO `blocks` VALUES (1,'Annetta Harvey DVM','annetta-harvey-dvm','Illo ipsa quia dolores odit aperiam.','Saepe autem animi et soluta esse. Architecto assumenda ut tempora aut nisi delectus consectetur. Et nihil molestiae dolor. Esse suscipit debitis magnam accusantium nemo illum. Dolor beatae nihil et sint et. Qui aliquam esse nihil. Placeat dolorem hic occaecati adipisci est. Nihil ab modi unde asperiores aut. Molestias nesciunt illum exercitationem et et sit.','published',NULL,'2025-10-22 06:36:27','2025-10-22 06:36:27',NULL),(2,'Manuel Ernser II','manuel-ernser-ii','Voluptatem exercitationem soluta sint aut in.','Voluptatum ut nisi aliquam sunt totam maiores. Velit nesciunt non autem ea distinctio beatae. Tenetur impedit sunt est cupiditate fugit. Iusto architecto labore perspiciatis culpa aut. Amet cum reprehenderit corporis magni et eligendi quasi. Perspiciatis quis necessitatibus exercitationem quidem voluptas repellendus veniam. Qui impedit quibusdam reiciendis eos eos nulla. Dolore eos sed deleniti praesentium est provident officia occaecati.','published',NULL,'2025-10-22 06:36:27','2025-10-22 06:36:27',NULL),(3,'Tremayne Barrows','tremayne-barrows','Odio beatae aut eligendi neque qui.','Occaecati deserunt qui autem cum. In maxime harum vero rerum et. Enim et quo sunt similique sit. In inventore ex laborum illum voluptatem error adipisci. Perspiciatis deserunt error fugiat sunt blanditiis et blanditiis. Tempore vero ullam sed minus eligendi nisi cumque. Quidem quisquam ipsum voluptas ab voluptates.','published',NULL,'2025-10-22 06:36:27','2025-10-22 06:36:27',NULL),(4,'Kelsi Hoeger II','kelsi-hoeger-ii','Voluptatibus quae totam aut sed aut.','Vitae sint labore debitis eius veniam natus blanditiis fuga. Cupiditate quisquam voluptatum illum nobis. Adipisci qui eum esse dolor. Mollitia tempore atque delectus qui architecto inventore officia aut. Earum ratione assumenda et sint et nobis error. Et sapiente laudantium sint magni harum nam. Enim ut officia quisquam. Hic aut minima sed eveniet officia id. Rem eius beatae aut accusamus quod. Ut dolore distinctio unde animi.','published',NULL,'2025-10-22 06:36:27','2025-10-22 06:36:27',NULL),(5,'Sophia Torphy','sophia-torphy','Quae optio magni at.','Et voluptatibus enim quasi totam. Molestias ex voluptatem non qui quis itaque ratione. Illo modi numquam quas fugit rem vero repellat. Ullam amet ipsam harum non numquam ut molestiae. Debitis laborum qui dolores saepe error. Voluptas libero occaecati quisquam quis. Qui laborum rerum molestiae. Est voluptas architecto in quos. Adipisci enim harum autem odio maiores quaerat quibusdam aut. Id aut ut ducimus hic animi nisi.','published',NULL,'2025-10-22 06:36:27','2025-10-22 06:36:27',NULL);
/*!40000 ALTER TABLE `blocks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blocks_translations`
--

DROP TABLE IF EXISTS `blocks_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `blocks_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `blocks_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `raw_content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`blocks_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blocks_translations`
--

LOCK TABLES `blocks_translations` WRITE;
/*!40000 ALTER TABLE `blocks_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `blocks_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Artificial Intelligence',0,'Provident quod pariatur qui. Provident earum voluptatem tempore at minima repellat. Necessitatibus voluptatem molestias iusto excepturi et ratione rerum.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(2,'Cybersecurity',0,'Eos sit impedit delectus accusantium voluptas omnis et sit. Hic ut est inventore qui quia. Reprehenderit voluptatem id quo quidem asperiores sapiente. Sint velit et placeat ipsa quo quia.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(3,'Blockchain Technology',0,'Ab distinctio aut quibusdam sequi. Omnis laboriosam blanditiis beatae error. Sed ad natus quia dolores.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(4,'5G and Connectivity',0,'Architecto reiciendis exercitationem aut in. Quis fugit et ut quia minima dolores. In cumque iusto quos. Dolorem rerum aut qui magni sed vel perferendis.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(5,'Augmented Reality (AR)',0,'Sed aut dolorem eius sequi repudiandae ad vero quisquam. Incidunt est ad accusantium sit et sunt officia occaecati. Aut non impedit vitae ratione quo. Impedit odio et optio eos eveniet.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(6,'Green Technology',0,'Dolor aut quisquam qui. Hic enim ex nobis voluptas qui rerum architecto officia. Sequi laudantium error et aut ut harum velit nobis. Qui in commodi odio in.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(7,'Quantum Computing',0,'Illo facilis quia et laborum eos sequi. Maiores dolorem dolor quae temporibus earum exercitationem laborum. Et qui impedit aut sit molestias.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(8,'Edge Computing',0,'Vero nam quas est est quas. Optio eius enim alias commodi qui accusantium. Quia commodi amet voluptas. Odit similique aliquid quia pariatur aspernatur corporis.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-10-22 06:36:19','2025-10-22 06:36:19');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Katharina Nikolaus','ehansen@example.org','(906) 866-2917','31323 Paul Spurs Suite 235\nDoloreschester, CA 05127','Est voluptatem nam porro porro alias voluptatem.','Placeat officiis reprehenderit occaecati ut. In harum quae expedita aut ut et voluptatem officiis. Tempore sed sunt et asperiores ullam corporis est. Quo quis deserunt quam itaque dolor delectus molestiae. Dolore eius quia et aut. Blanditiis quo et dolor aut aut non. Aut sed voluptas facere sunt sequi est. Ab ut voluptate nihil tempore possimus ipsum quia.',NULL,'unread','2025-10-22 06:36:26','2025-10-22 06:36:26'),(2,'Rossie Weissnat','dooley.arjun@example.org','+1-480-201-7099','36978 Kemmer Run\nNorth Griffin, DE 17377','Fugit aut architecto nobis rerum dolores veniam.','Qui quibusdam nisi et vel. Expedita aut beatae dolor corrupti doloremque. Earum dolor dolorem quis fugit laboriosam veniam. Quia qui est dolores aut inventore itaque. Quos in quo fugiat fugit dolor tempore. Porro deserunt blanditiis dolorem et. Debitis quas et deserunt qui aliquam. Autem numquam maxime illum cumque quia. Assumenda molestiae accusantium nobis est ipsa explicabo labore. Ut aliquam inventore consequatur beatae magni voluptatibus voluptas.',NULL,'unread','2025-10-22 06:36:26','2025-10-22 06:36:26'),(3,'Gilda Cole','jayden.effertz@example.net','+1-530-304-8779','87063 Miles Falls\nLake Raleigh, IA 87027','Vitae laborum esse nulla iure eos dicta.','Culpa nihil consequatur omnis pariatur. Repellat consequatur animi sunt nulla. Voluptatem ullam harum deserunt eum harum accusantium sapiente. Quis velit occaecati unde est provident sunt sunt. Voluptas sapiente expedita qui sint. Aperiam quas ad adipisci aliquid. Sed optio occaecati et quaerat molestiae neque sint ut. Sunt amet totam eum alias tempore. Ab quia beatae voluptatem labore. Consequatur nisi molestiae corporis.',NULL,'read','2025-10-22 06:36:26','2025-10-22 06:36:26'),(4,'Judah Murazik','marks.brice@example.net','312.784.0280','36598 Runte Manor Suite 972\nWaelchiborough, OK 39304','Sint laborum et accusantium in non et.','Optio minima harum pariatur similique libero voluptatem. Est quia provident dolores hic nulla ea corporis. Illo voluptatum optio ratione. Delectus eum repudiandae dicta aut. Vero in est soluta sunt id. Voluptatem autem aut enim recusandae amet quo. Aspernatur exercitationem aut accusantium sed. Dignissimos beatae animi eveniet quidem iste velit aut. Atque perspiciatis sapiente tenetur soluta.',NULL,'unread','2025-10-22 06:36:26','2025-10-22 06:36:26'),(5,'Joan Vandervort','tstokes@example.com','+1.564.990.0864','67590 Angus Burg\nMarceloport, IA 41019-6672','Temporibus quia qui cumque facere est.','Harum placeat nisi illo perspiciatis. Saepe omnis qui aliquid. Laboriosam at dolores expedita. Aut rem et sit aliquid vitae porro qui. Similique laboriosam beatae sapiente qui sit et. Saepe nihil illum fuga animi rem fugiat ducimus cumque. Sed minus velit voluptatibus. Aspernatur totam nostrum in enim incidunt cum. Labore doloremque id harum labore eum molestiae sint. Quos voluptas unde est et.',NULL,'read','2025-10-22 06:36:26','2025-10-22 06:36:26'),(6,'Akeem O\'Conner','vern91@example.org','(857) 404-0888','2933 Mitchell Parkway\nPort Zachariahton, NV 94183','Facere consequatur commodi ratione ad placeat.','Qui reiciendis et ut ratione quia. Animi aut debitis qui ducimus quis magnam nisi. Impedit modi voluptate vel. Nemo quos optio aliquid magni neque maxime vero ut. Veniam est asperiores consequatur ipsa est. Repellendus eveniet molestiae tempora quod qui ut. Vel ea ut accusamus reiciendis quidem voluptas laboriosam aut. Soluta voluptas quaerat molestias delectus harum sunt. Voluptas amet ut voluptates eius eveniet. Autem pariatur ut eum.',NULL,'unread','2025-10-22 06:36:26','2025-10-22 06:36:26'),(7,'Kelly Senger','hayden.parker@example.com','(928) 620-1849','96648 Wendell Throughway\nPort Lauretta, NV 01124','Reiciendis et explicabo cum et quia.','Dolorem molestiae neque sit laudantium quis. At voluptate molestiae beatae possimus dicta rem eum. Eius autem omnis aliquam non. Omnis saepe ut itaque qui laudantium fugit iusto. Adipisci facere reiciendis voluptatem iusto exercitationem est. Cumque harum sunt consectetur enim. Molestiae repudiandae nam eos odit. Aut placeat et vel laudantium iure.',NULL,'unread','2025-10-22 06:36:27','2025-10-22 06:36:27'),(8,'Verona Kerluke','green.melisa@example.com','+1-678-987-6516','341 Terrell Greens\nNew Manuel, FL 06995','Veniam sint et sint ipsam.','Illum ipsa dolor ab qui et exercitationem doloribus. Et sit quos et ut doloremque veritatis. Dicta harum illo culpa sint quae asperiores deleniti. Corporis aperiam unde nobis optio. Tempore expedita culpa ut et officiis perferendis consequatur. Sequi aliquam eveniet qui voluptate. Vel aspernatur blanditiis magni sed. Quo deleniti velit error ut autem. Nihil sit perspiciatis maxime quia vel fugit. Et incidunt consequatur odio repudiandae fugit. Quasi perferendis rerum sit atque.',NULL,'unread','2025-10-22 06:36:27','2025-10-22 06:36:27'),(9,'Dr. Frida Adams','reese.murazik@example.org','+1.253.989.2716','21987 Wilkinson Way Apt. 967\nNorth Nina, AZ 05354','Dolore est est commodi.','Est aut illo voluptas aut a sunt. Nisi commodi natus dolores nemo est quia. Magnam perferendis et ex quia. Occaecati exercitationem ea quis quo fuga in. Consequatur nulla temporibus provident. Cum dolorem et culpa voluptatum. Tempora ut voluptas tempora harum. Reiciendis pariatur veritatis ipsam occaecati sit eos ex. Ad consequatur magni culpa non eos sed qui. Fugit quia consequatur cumque commodi laborum. Reprehenderit harum sit tempore rerum aut repudiandae.',NULL,'read','2025-10-22 06:36:27','2025-10-22 06:36:27'),(10,'Floy Green','marley82@example.com','1-484-239-1429','61788 Conn Rapid Suite 673\nEast Karleyhaven, TX 17561','Laborum consequatur et asperiores sed.','Pariatur accusantium et et neque laudantium ipsum quaerat qui. Cupiditate harum totam recusandae reiciendis eum aut ab. Maiores qui odio inventore aspernatur nam. Dolor magnam aliquam amet sequi aut ut. Vel vel quo et optio molestiae nesciunt. Ab voluptas nisi harum quibusdam quibusdam. Non fuga molestiae non similique hic. Laudantium aut ut commodi consequatur nobis corrupti ducimus.',NULL,'read','2025-10-22 06:36:27','2025-10-22 06:36:27');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_fields`
--

DROP TABLE IF EXISTS `custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `use_for` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `use_for_id` bigint unsigned NOT NULL,
  `field_item_id` bigint unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `custom_fields_field_item_id_index` (`field_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_fields`
--

LOCK TABLES `custom_fields` WRITE;
/*!40000 ALTER TABLE `custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_fields_translations`
--

DROP TABLE IF EXISTS `custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields_id` bigint unsigned NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_fields_translations`
--

LOCK TABLES `custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `device_tokens`
--

DROP TABLE IF EXISTS `device_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `device_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `device_tokens_token_unique` (`token`),
  KEY `device_tokens_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `device_tokens_platform_is_active_index` (`platform`,`is_active`),
  KEY `device_tokens_is_active_index` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `device_tokens`
--

LOCK TABLES `device_tokens` WRITE;
/*!40000 ALTER TABLE `device_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `device_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_groups`
--

DROP TABLE IF EXISTS `field_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `field_groups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rules` text COLLATE utf8mb4_unicode_ci,
  `order` int NOT NULL DEFAULT '0',
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `field_groups_created_by_index` (`created_by`),
  KEY `field_groups_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_groups`
--

LOCK TABLES `field_groups` WRITE;
/*!40000 ALTER TABLE `field_groups` DISABLE KEYS */;
INSERT INTO `field_groups` VALUES (1,'Post Additional Information','[[{\"name\":\"model_name\",\"type\":\"==\",\"value\":\"Botble\\\\Blog\\\\Models\\\\Post\"}]]',0,1,1,'published','2025-10-22 06:36:27','2025-10-22 06:36:27'),(2,'Page Custom Fields','[[{\"name\":\"model_name\",\"type\":\"==\",\"value\":\"Botble\\\\Page\\\\Models\\\\Page\"}]]',1,1,1,'published','2025-10-22 06:36:27','2025-10-22 06:36:27');
/*!40000 ALTER TABLE `field_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_items`
--

DROP TABLE IF EXISTS `field_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `field_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `field_group_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned DEFAULT NULL,
  `order` int DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instructions` text COLLATE utf8mb4_unicode_ci,
  `options` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `field_items_field_group_id_index` (`field_group_id`),
  KEY `field_items_parent_id_index` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_items`
--

LOCK TABLES `field_items` WRITE;
/*!40000 ALTER TABLE `field_items` DISABLE KEYS */;
INSERT INTO `field_items` VALUES (1,1,NULL,0,'Post Options','post_options','checkbox','Select post display options','{\"selectChoices\":\"featured:Featured post\\nsticky:Sticky post\\nshow_author:Show author\\nallow_comments:Allow comments\\nshow_date:Show publish date\"}'),(2,1,NULL,1,'Reading Time','reading_time','number','Estimated reading time in minutes','{\"placeholderText\":\"5\",\"defaultValue\":\"5\",\"min\":1,\"max\":60}'),(3,1,NULL,2,'External Source','external_source','text','Link to external source or reference','{\"placeholderText\":\"https:\\/\\/example.com\\/article\"}'),(4,1,NULL,3,'Post Type','post_type','select','Select the type of post','{\"selectChoices\":\"article:Article\\nnews:News\\ntutorial:Tutorial\\nreview:Review\",\"defaultValue\":\"article\"}'),(5,1,NULL,4,'Custom Excerpt','custom_excerpt','textarea','Custom excerpt for social media sharing','{\"placeholderText\":\"Enter a brief summary...\",\"rows\":3}'),(6,1,NULL,5,'Sponsored By','sponsored_by','text','Sponsor name (if applicable)','{\"placeholderText\":\"Company name\"}'),(7,2,NULL,0,'Hero Banner','hero_banner','image','Upload a hero banner image for this page','{\"allow_thumb\":true}'),(8,2,NULL,1,'Page Subtitle','page_subtitle','text','Add a subtitle or tagline for this page','{\"placeholderText\":\"Enter page subtitle\"}'),(9,2,NULL,2,'Call to Action','cta_button','text','Call to action button text','{\"placeholderText\":\"Learn More\"}'),(10,2,NULL,3,'CTA Link','cta_link','text','URL for the call to action button','{\"placeholderText\":\"https:\\/\\/example.com\\/contact\"}'),(11,2,NULL,4,'Page Layout','page_layout','radio','Select the page layout','{\"selectChoices\":\"default:Default Layout\\nsidebar-left:Left Sidebar\\nsidebar-right:Right Sidebar\\nfull-width:Full Width\",\"defaultValue\":\"default\"}'),(12,2,NULL,5,'Page Settings','page_settings','checkbox','Select page display options','{\"selectChoices\":\"hide_title:Hide page title\\nhide_breadcrumb:Hide breadcrumb\\nhide_sidebar:Hide sidebar\\nhide_footer:Hide footer\"}');
/*!40000 ALTER TABLE `field_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fob_comments`
--

DROP TABLE IF EXISTS `fob_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fob_comments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reply_to` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fob_comments_author_type_author_id_index` (`author_type`,`author_id`),
  KEY `fob_comments_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `fob_comments_reply_to_index` (`reply_to`),
  KEY `fob_comments_reference_url_index` (`reference_url`),
  KEY `fob_comments_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fob_comments`
--

LOCK TABLES `fob_comments` WRITE;
/*!40000 ALTER TABLE `fob_comments` DISABLE KEYS */;
INSERT INTO `fob_comments` VALUES (1,NULL,'Botble\\Member\\Models\\Member',0,'Botble\\Blog\\Models\\Post',5,'https://botble.test','Dr. Guy Gislason I','umorissette@hotmail.com','https://friendsofbotble.com','This is really helpful, thank you!','approved','17.55.196.93','Mozilla/5.0 (X11; Linux i686) AppleWebKit/536.1 (KHTML, like Gecko) Chrome/91.0.4164.75 Safari/536.1 EdgA/91.01020.71','2025-10-10 08:36:16','2025-10-22 06:36:27'),(2,NULL,'Botble\\Member\\Models\\Member',5,'Botble\\Blog\\Models\\Post',17,'https://botble.test','Prof. Alexzander Bailey DVM','rpouros@hahn.com','https://friendsofbotble.com','I found this article to be quite informative.','approved','64.254.195.242','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_1 rv:2.0) Gecko/20190610 Firefox/35.0','2025-10-11 21:50:44','2025-10-22 06:36:27'),(3,NULL,'Botble\\Member\\Models\\Member',5,'Botble\\Blog\\Models\\Post',19,'https://botble.test','Thaddeus Spencer','jadyn83@yahoo.com','https://friendsofbotble.com','Wow, I never knew about this before!','approved','29.129.236.1','Mozilla/5.0 (Macintosh; U; PPC Mac OS X 10_7_6 rv:2.0; sl-SI) AppleWebKit/535.17.5 (KHTML, like Gecko) Version/5.1 Safari/535.17.5','2025-10-21 05:34:57','2025-10-22 06:36:27'),(4,NULL,'Botble\\Member\\Models\\Member',11,'Botble\\Blog\\Models\\Post',19,'https://botble.test','Laura Mante','khalil.oreilly@schmeler.com','https://friendsofbotble.com','Great job on explaining such a complex topic.','approved','51.48.91.196','Opera/8.57 (Windows 98; Win 9x 4.90; en-US) Presto/2.12.261 Version/12.00','2025-09-24 10:13:10','2025-10-22 06:36:27'),(5,NULL,'Botble\\Member\\Models\\Member',7,'Botble\\Blog\\Models\\Post',7,'https://botble.test','Kendall Marvin','eleazar.huels@hotmail.com','https://friendsofbotble.com','I have a question about the third paragraph.','approved','121.92.169.151','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_0) AppleWebKit/531.2 (KHTML, like Gecko) Chrome/80.0.4275.22 Safari/531.2 Edg/80.01010.65','2025-10-21 04:29:11','2025-10-22 06:36:27'),(6,NULL,'Botble\\Member\\Models\\Member',3,'Botble\\Blog\\Models\\Post',16,'https://botble.test','Alessandra Zemlak','schmeler.jenifer@gmail.com','https://friendsofbotble.com','This article changed my perspective entirely.','approved','138.140.225.135','Mozilla/5.0 (X11; Linux i686) AppleWebKit/5320 (KHTML, like Gecko) Chrome/40.0.864.0 Mobile Safari/5320','2025-09-30 19:14:36','2025-10-22 06:36:27'),(7,NULL,'Botble\\Member\\Models\\Member',5,'Botble\\Blog\\Models\\Post',2,'https://botble.test','Miguel Walter','santa56@hotmail.com','https://friendsofbotble.com','I appreciate the effort you put into this.','approved','69.227.99.32','Mozilla/5.0 (iPhone; CPU iPhone OS 13_2 like Mac OS X) AppleWebKit/532.1 (KHTML, like Gecko) Version/15.0 EdgiOS/85.01029.9 Mobile/15E148 Safari/532.1','2025-10-02 07:12:11','2025-10-22 06:36:27'),(8,NULL,'Botble\\Member\\Models\\Member',0,'Botble\\Blog\\Models\\Post',14,'https://botble.test','Estell Haag','ikiehn@hotmail.com','https://friendsofbotble.com','This is exactly what I was looking for, thank you!','approved','155.130.121.123','Opera/8.53 (Windows NT 5.2; nl-NL) Presto/2.11.282 Version/11.00','2025-09-26 14:03:59','2025-10-22 06:36:27'),(9,NULL,'Botble\\Member\\Models\\Member',12,'Botble\\Blog\\Models\\Post',14,'https://botble.test','Prof. Harry Robel II','major.walsh@gmail.com','https://friendsofbotble.com','I disagree with some points mentioned here, though.','approved','24.57.111.237','Mozilla/5.0 (compatible; MSIE 11.0; Windows 98; Trident/3.0)','2025-10-02 12:24:31','2025-10-22 06:36:27'),(10,NULL,'Botble\\Member\\Models\\Member',5,'Botble\\Blog\\Models\\Post',11,'https://botble.test','Prof. Urban Hackett','caitlyn64@heidenreich.biz','https://friendsofbotble.com','Could you provide more examples to illustrate your point?','approved','196.86.64.110','Mozilla/5.0 (iPhone; CPU iPhone OS 8_1_1 like Mac OS X; nl-NL) AppleWebKit/532.45.3 (KHTML, like Gecko) Version/3.0.5 Mobile/8B117 Safari/6532.45.3','2025-09-23 03:56:48','2025-10-22 06:36:27'),(11,NULL,'Botble\\Member\\Models\\Member',13,'Botble\\Blog\\Models\\Post',8,'https://botble.test','Abbigail Jacobi','kovacek.candelario@schaefer.net','https://friendsofbotble.com','I wish there were more articles like this out there.','approved','175.239.193.14','Mozilla/5.0 (Windows; U; Windows NT 4.0) AppleWebKit/534.21.7 (KHTML, like Gecko) Version/5.0.3 Safari/534.21.7','2025-09-24 16:54:27','2025-10-22 06:36:27'),(12,NULL,'Botble\\Member\\Models\\Member',8,'Botble\\Blog\\Models\\Post',16,'https://botble.test','Prof. Noemy Kohler V','leffler.josue@gmail.com','https://friendsofbotble.com','I\'m bookmarking this for future reference.','approved','220.228.105.37','Mozilla/5.0 (Windows CE) AppleWebKit/5360 (KHTML, like Gecko) Chrome/37.0.828.0 Mobile Safari/5360','2025-10-19 17:47:44','2025-10-22 06:36:27'),(13,NULL,'Botble\\Member\\Models\\Member',13,'Botble\\Blog\\Models\\Post',4,'https://botble.test','Juston Stark DVM','ucollier@yahoo.com','https://friendsofbotble.com','I\'ve shared this with my friends, they loved it!','approved','26.87.250.227','Opera/8.35 (X11; Linux i686; en-US) Presto/2.8.203 Version/10.00','2025-10-01 18:10:39','2025-10-22 06:36:27'),(14,NULL,'Botble\\Member\\Models\\Member',9,'Botble\\Blog\\Models\\Post',5,'https://botble.test','Guillermo Marvin PhD','agustin.weber@goldner.com','https://friendsofbotble.com','This article is a must-read for everyone interested in the topic.','approved','176.196.90.6','Mozilla/5.0 (Windows NT 5.1) AppleWebKit/532.0 (KHTML, like Gecko) Chrome/99.0.4674.81 Safari/532.0 Edg/99.01070.39','2025-10-01 05:31:52','2025-10-22 06:36:27'),(15,NULL,'Botble\\Member\\Models\\Member',9,'Botble\\Blog\\Models\\Post',20,'https://botble.test','Alberto Yost','april80@koss.com','https://friendsofbotble.com','Thank you for shedding light on this important issue.','approved','119.241.66.43','Mozilla/5.0 (Windows NT 5.2) AppleWebKit/5322 (KHTML, like Gecko) Chrome/36.0.867.0 Mobile Safari/5322','2025-09-30 21:11:40','2025-10-22 06:36:27'),(16,NULL,'Botble\\Member\\Models\\Member',9,'Botble\\Blog\\Models\\Post',12,'https://botble.test','Dr. Joshuah Herman','osteuber@gmail.com','https://friendsofbotble.com','I\'ve been searching for information on this topic, glad I found this article.','approved','39.195.156.63','Mozilla/5.0 (iPhone; CPU iPhone OS 14_2 like Mac OS X) AppleWebKit/537.0 (KHTML, like Gecko) Version/15.0 EdgiOS/92.01022.90 Mobile/15E148 Safari/537.0','2025-10-10 16:44:41','2025-10-22 06:36:27'),(17,NULL,'Botble\\Member\\Models\\Member',1,'Botble\\Blog\\Models\\Post',3,'https://botble.test','Prof. Viviane Hintz I','bonita.ebert@hotmail.com','https://friendsofbotble.com','I\'m blown away by the insights shared in this article.','approved','33.158.162.98','Mozilla/5.0 (compatible; MSIE 6.0; Windows NT 5.01; Trident/3.1)','2025-10-03 05:52:12','2025-10-22 06:36:27'),(18,NULL,'Botble\\Member\\Models\\Member',12,'Botble\\Blog\\Models\\Post',5,'https://botble.test','Michel Kuhic','plangworth@yahoo.com','https://friendsofbotble.com','This article tackles a complex topic with clarity.','approved','93.147.60.72','Mozilla/5.0 (Windows NT 5.2) AppleWebKit/534.0 (KHTML, like Gecko) Chrome/89.0.4004.44 Safari/534.0 Edg/89.01110.36','2025-10-13 01:08:40','2025-10-22 06:36:27'),(19,NULL,'Botble\\Member\\Models\\Member',13,'Botble\\Blog\\Models\\Post',7,'https://botble.test','Jewell Hill I','shanahan.xzavier@corkery.com','https://friendsofbotble.com','I\'m going to reflect on the ideas presented in this article.','approved','156.85.124.241','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_0) AppleWebKit/533.2 (KHTML, like Gecko) Chrome/88.0.4700.61 Safari/533.2 Edg/88.01027.15','2025-09-29 12:07:32','2025-10-22 06:36:27'),(20,NULL,'Botble\\Member\\Models\\Member',14,'Botble\\Blog\\Models\\Post',3,'https://botble.test','Prof. Kennedy Boyle','laron16@lockman.com','https://friendsofbotble.com','The author\'s passion for the subject shines through in this article.','approved','57.13.66.195','Opera/9.15 (X11; Linux x86_64; sl-SI) Presto/2.12.260 Version/11.00','2025-10-11 12:04:11','2025-10-22 06:36:27'),(21,NULL,'Botble\\Member\\Models\\Member',5,'Botble\\Blog\\Models\\Post',2,'https://botble.test','Darien Dare','king.berta@wyman.biz','https://friendsofbotble.com','This article challenged my preconceptions in a thought-provoking way.','approved','157.68.37.189','Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_1 rv:6.0) Gecko/20140111 Firefox/35.0','2025-10-07 02:08:37','2025-10-22 06:36:27'),(22,NULL,'Botble\\Member\\Models\\Member',10,'Botble\\Blog\\Models\\Post',9,'https://botble.test','Jeromy Bashirian','theodora76@gmail.com','https://friendsofbotble.com','I\'ve added this article to my reading list, it\'s worth revisiting.','approved','168.48.85.47','Mozilla/5.0 (Macintosh; U; PPC Mac OS X 10_8_2) AppleWebKit/537.2 (KHTML, like Gecko) Chrome/80.0.4828.98 Safari/537.2 Edg/80.01089.73','2025-10-06 10:11:33','2025-10-22 06:36:27'),(23,NULL,'Botble\\Member\\Models\\Member',10,'Botble\\Blog\\Models\\Post',2,'https://botble.test','Jaren Kutch','conor.schuster@hotmail.com','https://friendsofbotble.com','This article offers practical advice that I can apply in real life.','approved','44.30.172.74','Mozilla/5.0 (compatible; MSIE 8.0; Windows CE; Trident/5.1)','2025-10-21 16:36:15','2025-10-22 06:36:27'),(24,NULL,'Botble\\Member\\Models\\Member',2,'Botble\\Blog\\Models\\Post',12,'https://botble.test','Rosie D\'Amore','rhiannon.bradtke@hotmail.com','https://friendsofbotble.com','I\'m going to recommend this article to my study group.','approved','163.151.20.175','Mozilla/5.0 (compatible; MSIE 11.0; Windows 95; Trident/5.0)','2025-10-06 14:08:08','2025-10-22 06:36:27'),(25,NULL,'Botble\\Member\\Models\\Member',4,'Botble\\Blog\\Models\\Post',12,'https://botble.test','Aletha Hickle','egerhold@yahoo.com','https://friendsofbotble.com','The examples provided really helped me understand the concept better.','approved','130.8.134.134','Mozilla/5.0 (Windows; U; Windows NT 6.1) AppleWebKit/531.34.6 (KHTML, like Gecko) Version/5.0.2 Safari/531.34.6','2025-10-08 01:34:49','2025-10-22 06:36:27'),(26,NULL,'Botble\\Member\\Models\\Member',9,'Botble\\Blog\\Models\\Post',11,'https://botble.test','Giovani Herman','wuckert.elnora@larkin.com','https://friendsofbotble.com','I resonate with the ideas presented here.','approved','229.196.51.195','Mozilla/5.0 (compatible; MSIE 7.0; Windows NT 6.0; Trident/5.0)','2025-10-09 12:21:47','2025-10-22 06:36:27'),(27,NULL,'Botble\\Member\\Models\\Member',10,'Botble\\Blog\\Models\\Post',13,'https://botble.test','Keyon Effertz','ola35@harris.org','https://friendsofbotble.com','This article made me think critically about the topic.','approved','205.12.157.243','Mozilla/5.0 (compatible; MSIE 7.0; Windows CE; Trident/5.0)','2025-09-23 17:38:17','2025-10-22 06:36:27'),(28,NULL,'Botble\\Member\\Models\\Member',4,'Botble\\Blog\\Models\\Post',14,'https://botble.test','Dominique Mohr','orn.jerome@gmail.com','https://friendsofbotble.com','I\'ll definitely come back to this article for reference.','approved','74.35.232.251','Mozilla/5.0 (Macintosh; U; PPC Mac OS X 10_7_1) AppleWebKit/5351 (KHTML, like Gecko) Chrome/37.0.879.0 Mobile Safari/5351','2025-10-16 05:12:49','2025-10-22 06:36:27'),(29,NULL,'Botble\\Member\\Models\\Member',12,'Botble\\Blog\\Models\\Post',8,'https://botble.test','Mr. Westley Nikolaus','cpowlowski@wehner.biz','https://friendsofbotble.com','I\'ve shared this on social media, it\'s too good not to share.','approved','11.163.187.124','Mozilla/5.0 (iPad; CPU OS 7_1_2 like Mac OS X; en-US) AppleWebKit/534.10.6 (KHTML, like Gecko) Version/4.0.5 Mobile/8B111 Safari/6534.10.6','2025-10-17 01:29:07','2025-10-22 06:36:27'),(30,NULL,'Botble\\Member\\Models\\Member',14,'Botble\\Blog\\Models\\Post',16,'https://botble.test','Joey Windler','craig62@gmail.com','https://friendsofbotble.com','This article presents a balanced view on a controversial topic.','approved','156.250.92.7','Mozilla/5.0 (X11; Linux i686; rv:7.0) Gecko/20140527 Firefox/36.0','2025-09-27 18:09:13','2025-10-22 06:36:27'),(31,NULL,'Botble\\Member\\Models\\Member',6,'Botble\\Blog\\Models\\Post',19,'https://botble.test','Collin Pfeffer MD','jhickle@hotmail.com','https://friendsofbotble.com','I\'m glad I stumbled upon this article, it\'s a gem.','approved','62.187.39.224','Opera/8.52 (X11; Linux x86_64; sl-SI) Presto/2.11.185 Version/11.00','2025-10-19 07:07:16','2025-10-22 06:36:27'),(32,NULL,'Botble\\Member\\Models\\Member',3,'Botble\\Blog\\Models\\Post',4,'https://botble.test','Rene Upton','schumm.christiana@lockman.net','https://friendsofbotble.com','I\'ve been struggling with this, your article helped a lot.','approved','108.170.17.100','Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_8) AppleWebKit/533.0 (KHTML, like Gecko) Chrome/90.0.4231.25 Safari/533.0 Edg/90.01045.8','2025-09-30 02:54:35','2025-10-22 06:36:27'),(33,NULL,'Botble\\Member\\Models\\Member',13,'Botble\\Blog\\Models\\Post',7,'https://botble.test','Cayla Christiansen','ward.loren@hotmail.com','https://friendsofbotble.com','I\'ve learned something new today, thanks to this article.','approved','253.123.40.90','Mozilla/5.0 (Macintosh; PPC Mac OS X 10_8_9 rv:6.0; en-US) AppleWebKit/532.23.4 (KHTML, like Gecko) Version/5.0 Safari/532.23.4','2025-10-11 08:27:06','2025-10-22 06:36:27'),(34,NULL,'Botble\\Member\\Models\\Member',10,'Botble\\Blog\\Models\\Post',7,'https://botble.test','Beau Mante','reese.lesch@yahoo.com','https://friendsofbotble.com','Kudos to the author for a well-researched piece.','approved','180.206.112.83','Mozilla/5.0 (Macintosh; U; PPC Mac OS X 10_5_3) AppleWebKit/5320 (KHTML, like Gecko) Chrome/40.0.893.0 Mobile Safari/5320','2025-10-20 02:28:54','2025-10-22 06:36:27'),(35,NULL,'Botble\\Member\\Models\\Member',9,'Botble\\Blog\\Models\\Post',18,'https://botble.test','Mrs. Yessenia Becker II','vondricka@hotmail.com','https://friendsofbotble.com','I\'m impressed by the depth of knowledge demonstrated here.','approved','92.97.144.235','Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/532.2 (KHTML, like Gecko) Chrome/88.0.4770.97 Safari/532.2 EdgA/88.01007.30','2025-10-08 17:21:32','2025-10-22 06:36:27'),(36,NULL,'Botble\\Member\\Models\\Member',7,'Botble\\Blog\\Models\\Post',10,'https://botble.test','Mr. Turner Kerluke III','gregoria41@yahoo.com','https://friendsofbotble.com','This article challenged my assumptions in a good way.','approved','36.70.162.49','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_7 rv:2.0) Gecko/20190807 Firefox/35.0','2025-09-24 22:31:39','2025-10-22 06:36:27'),(37,NULL,'Botble\\Member\\Models\\Member',1,'Botble\\Blog\\Models\\Post',18,'https://botble.test','Cruz Romaguera','towne.kathryne@bogan.com','https://friendsofbotble.com','I\'ve shared this with my colleagues, it\'s worth discussing.','approved','222.105.126.89','Mozilla/5.0 (compatible; MSIE 11.0; Windows NT 5.01; Trident/4.1)','2025-10-10 17:39:41','2025-10-22 06:36:27'),(38,NULL,'Botble\\Member\\Models\\Member',10,'Botble\\Blog\\Models\\Post',17,'https://botble.test','Dr. Beverly Beer PhD','rylee31@hotmail.com','https://friendsofbotble.com','The information presented here is very valuable.','approved','255.86.1.202','Mozilla/5.0 (compatible; MSIE 6.0; Windows NT 4.0; Trident/3.1)','2025-10-18 23:24:42','2025-10-22 06:36:27'),(39,NULL,'Botble\\Member\\Models\\Member',5,'Botble\\Blog\\Models\\Post',16,'https://botble.test','Dr. Morgan Kovacek I','carlo.volkman@yahoo.com','https://friendsofbotble.com','You have a talent for explaining complex topics clearly.','approved','120.250.247.246','Mozilla/5.0 (compatible; MSIE 6.0; Windows NT 4.0; Trident/4.0)','2025-10-15 12:44:01','2025-10-22 06:36:27'),(40,NULL,'Botble\\Member\\Models\\Member',5,'Botble\\Blog\\Models\\Post',20,'https://botble.test','Judson Ondricka','graham.sandra@baumbach.com','https://friendsofbotble.com','I\'m inspired to learn more about this after reading your article.','approved','43.93.38.207','Mozilla/5.0 (compatible; MSIE 6.0; Windows NT 5.1; Trident/5.1)','2025-10-02 15:18:49','2025-10-22 06:36:27'),(41,NULL,'Botble\\Member\\Models\\Member',7,'Botble\\Blog\\Models\\Post',17,'https://botble.test','Leonora Raynor I','hartmann.jasmin@yahoo.com','https://friendsofbotble.com','This article deserves wider recognition.','approved','112.10.86.42','Mozilla/5.0 (X11; Linux i686; rv:5.0) Gecko/20110725 Firefox/37.0','2025-10-04 19:31:41','2025-10-22 06:36:27'),(42,NULL,'Botble\\Member\\Models\\Member',12,'Botble\\Blog\\Models\\Post',17,'https://botble.test','Glenda Cartwright PhD','dillan.kris@auer.org','https://friendsofbotble.com','I\'m grateful for the insights shared in this piece.','approved','94.76.102.111','Opera/9.49 (X11; Linux i686; sl-SI) Presto/2.11.206 Version/12.00','2025-09-23 03:17:25','2025-10-22 06:36:27'),(43,NULL,'Botble\\Member\\Models\\Member',0,'Botble\\Blog\\Models\\Post',18,'https://botble.test','Dr. Alexandria Mayer Jr.','evie69@yahoo.com','https://friendsofbotble.com','The author presents a balanced view on a controversial topic.','approved','14.78.184.131','Mozilla/5.0 (compatible; MSIE 11.0; Windows CE; Trident/3.1)','2025-10-13 15:28:24','2025-10-22 06:36:27'),(44,NULL,'Botble\\Member\\Models\\Member',7,'Botble\\Blog\\Models\\Post',4,'https://botble.test','Prof. Noe Turner','dickens.amy@zieme.info','https://friendsofbotble.com','I\'m glad I stumbled upon this article, it\'s','approved','181.17.203.122','Mozilla/5.0 (compatible; MSIE 8.0; Windows CE; Trident/3.0)','2025-09-27 18:23:06','2025-10-22 06:36:27'),(45,NULL,'Botble\\Member\\Models\\Member',12,'Botble\\Blog\\Models\\Post',3,'https://botble.test','Heaven Kuhn','dora28@gmail.com','https://friendsofbotble.com','I\'ve been searching for information on this topic, glad I found this article. It\'s incredibly insightful and provides a comprehensive overview of the subject matter. I appreciate the effort put into researching and writing this piece. It\'s truly eye-opening and has given me a new perspective. Thank you for sharing your knowledge with us!','approved','69.147.86.122','Opera/8.90 (Windows NT 6.0; sl-SI) Presto/2.10.162 Version/12.00','2025-10-16 10:51:05','2025-10-22 06:36:27'),(46,NULL,'Botble\\Member\\Models\\Member',8,'Botble\\Blog\\Models\\Post',20,'https://botble.test','Jules Stracke V','mike.kassulke@denesik.com','https://friendsofbotble.com','This article is a masterpiece! It dives deep into the topic and offers valuable insights that are both thought-provoking and enlightening. The author\'s expertise is evident throughout, making it a compelling read from start to finish. I\'ll definitely be coming back to this for reference in the future.','approved','156.55.137.42','Mozilla/5.0 (Windows; U; Windows NT 5.2) AppleWebKit/535.50.1 (KHTML, like Gecko) Version/4.0.4 Safari/535.50.1','2025-10-08 05:50:17','2025-10-22 06:36:27'),(47,NULL,'Botble\\Member\\Models\\Member',14,'Botble\\Blog\\Models\\Post',10,'https://botble.test','Haven Johnson','anika90@yahoo.com','https://friendsofbotble.com','I\'m amazed by the depth of analysis in this article. It covers a wide range of aspects related to the topic, providing a comprehensive understanding. The clarity of explanation is commendable, making complex concepts easy to grasp. This article has enriched my understanding and sparked further curiosity. Kudos to the author!','approved','132.175.161.186','Mozilla/5.0 (iPhone; CPU iPhone OS 15_0 like Mac OS X) AppleWebKit/531.1 (KHTML, like Gecko) Version/15.0 EdgiOS/81.01119.58 Mobile/15E148 Safari/531.1','2025-09-28 12:33:44','2025-10-22 06:36:27');
/*!40000 ALTER TABLE `fob_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Tech Conference 2024','Annual technology conference featuring keynote speakers, workshops, and networking opportunities for industry professionals.',1,0,'news/6.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(2,'Product Launch Event','Exclusive unveiling of our latest product line with live demonstrations and Q&amp;A sessions with the development team.',1,0,'news/7.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(3,'Team Building Retreat','Company-wide retreat focused on collaboration, innovation, and strengthening team bonds in a relaxed environment.',1,0,'news/8.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(4,'Innovation Summit','Two-day summit bringing together thought leaders to discuss emerging technologies and future trends.',1,0,'news/9.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(5,'Developer Meetup','Monthly gathering of developers to share knowledge, discuss best practices, and collaborate on open-source projects.',1,0,'news/10.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(6,'AI Workshop Series','Hands-on workshops covering machine learning, neural networks, and practical AI applications.',1,0,'news/11.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(7,'Startup Showcase','Platform for emerging startups to present their innovative solutions to investors and industry experts.',0,0,'news/12.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(8,'Company Anniversary','Celebrating our journey with employees, partners, and customers who made our success possible.',0,0,'news/13.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(9,'Hackathon Weekend','48-hour coding marathon where teams compete to build innovative solutions to real-world problems.',0,0,'news/14.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(10,'Industry Awards Night','Annual ceremony recognizing excellence and innovation in technology across various categories.',0,0,'news/15.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(11,'New Office Opening','Grand opening of our state-of-the-art facility designed to foster creativity and collaboration.',0,0,'news/16.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(12,'Community Outreach','Initiatives focused on giving back to the community through education and technology access programs.',0,0,'news/17.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(13,'Tech Talks Series','Weekly presentations by industry experts covering cutting-edge technologies and best practices.',0,0,'news/18.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(14,'Partnership Celebration','Commemorating strategic partnerships that drive innovation and mutual growth.',0,0,'news/19.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20'),(15,'Year in Review','Annual retrospective highlighting achievements, milestones, and setting vision for the future.',0,0,'news/20.jpg',1,'published','2025-10-22 06:36:20','2025-10-22 06:36:20');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(2,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(3,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(4,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(5,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(6,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(7,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(8,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(9,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(10,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(11,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(12,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(13,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(14,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20'),(15,'[{\"img\":\"news\\/1.jpg\",\"description\":\"Keynote speaker presenting on stage to packed auditorium\"},{\"img\":\"news\\/2.jpg\",\"description\":\"Team collaboration during breakout session\"},{\"img\":\"news\\/3.jpg\",\"description\":\"Networking event with industry professionals\"},{\"img\":\"news\\/4.jpg\",\"description\":\"Product demonstration at exhibition booth\"},{\"img\":\"news\\/5.jpg\",\"description\":\"Panel discussion with technology leaders\"},{\"img\":\"news\\/6.jpg\",\"description\":\"Hands-on coding workshop in progress\"},{\"img\":\"news\\/7.jpg\",\"description\":\"Award ceremony moment with winner on stage\"},{\"img\":\"news\\/8.jpg\",\"description\":\"Innovative product showcase and demo area\"},{\"img\":\"news\\/9.jpg\",\"description\":\"Team celebrating project completion\"},{\"img\":\"news\\/10.jpg\",\"description\":\"Audience engaged in Q&A session\"},{\"img\":\"news\\/11.jpg\",\"description\":\"Workshop participants working on laptops\"},{\"img\":\"news\\/12.jpg\",\"description\":\"Startup pitch presentation to investors\"},{\"img\":\"news\\/13.jpg\",\"description\":\"Company executives cutting ribbon at opening\"},{\"img\":\"news\\/14.jpg\",\"description\":\"Community members learning new skills\"},{\"img\":\"news\\/15.jpg\",\"description\":\"Technical demonstration of new features\"},{\"img\":\"news\\/16.jpg\",\"description\":\"Partners signing collaboration agreement\"},{\"img\":\"news\\/17.jpg\",\"description\":\"Team brainstorming in modern workspace\"},{\"img\":\"news\\/18.jpg\",\"description\":\"Conference attendees during coffee break\"},{\"img\":\"news\\/19.jpg\",\"description\":\"Innovation lab with latest technology\"},{\"img\":\"news\\/20.jpg\",\"description\":\"Closing ceremony group photo\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-10-22 06:36:20','2025-10-22 06:36:20');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','74f6cc8ba5d35e30fec5b1e88e150f1b',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','fce8dea5cb52c28f276c10d0dfdad4d8',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','c35b153e00742e7b14876be34b6e7c79',2,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'1','1',1,'image/jpeg',71367,'users/1.jpg','[]','2025-10-22 06:36:16','2025-10-22 06:36:16',NULL,'public'),(2,0,'1','1',2,'image/jpeg',9803,'news/1.jpg','[]','2025-10-22 06:36:17','2025-10-22 06:36:17',NULL,'public'),(3,0,'10','10',2,'image/jpeg',9803,'news/10.jpg','[]','2025-10-22 06:36:17','2025-10-22 06:36:17',NULL,'public'),(4,0,'11','11',2,'image/jpeg',9803,'news/11.jpg','[]','2025-10-22 06:36:17','2025-10-22 06:36:17',NULL,'public'),(5,0,'12','12',2,'image/jpeg',9803,'news/12.jpg','[]','2025-10-22 06:36:17','2025-10-22 06:36:17',NULL,'public'),(6,0,'13','13',2,'image/jpeg',9803,'news/13.jpg','[]','2025-10-22 06:36:17','2025-10-22 06:36:17',NULL,'public'),(7,0,'14','14',2,'image/jpeg',9803,'news/14.jpg','[]','2025-10-22 06:36:17','2025-10-22 06:36:17',NULL,'public'),(8,0,'15','15',2,'image/jpeg',9803,'news/15.jpg','[]','2025-10-22 06:36:18','2025-10-22 06:36:18',NULL,'public'),(9,0,'16','16',2,'image/jpeg',9803,'news/16.jpg','[]','2025-10-22 06:36:18','2025-10-22 06:36:18',NULL,'public'),(10,0,'17','17',2,'image/jpeg',9803,'news/17.jpg','[]','2025-10-22 06:36:18','2025-10-22 06:36:18',NULL,'public'),(11,0,'18','18',2,'image/jpeg',9803,'news/18.jpg','[]','2025-10-22 06:36:18','2025-10-22 06:36:18',NULL,'public'),(12,0,'19','19',2,'image/jpeg',9803,'news/19.jpg','[]','2025-10-22 06:36:18','2025-10-22 06:36:18',NULL,'public'),(13,0,'2','2',2,'image/jpeg',9803,'news/2.jpg','[]','2025-10-22 06:36:18','2025-10-22 06:36:18',NULL,'public'),(14,0,'20','20',2,'image/jpeg',9803,'news/20.jpg','[]','2025-10-22 06:36:18','2025-10-22 06:36:18',NULL,'public'),(15,0,'3','3',2,'image/jpeg',9803,'news/3.jpg','[]','2025-10-22 06:36:18','2025-10-22 06:36:18',NULL,'public'),(16,0,'4','4',2,'image/jpeg',9803,'news/4.jpg','[]','2025-10-22 06:36:18','2025-10-22 06:36:18',NULL,'public'),(17,0,'5','5',2,'image/jpeg',9803,'news/5.jpg','[]','2025-10-22 06:36:19','2025-10-22 06:36:19',NULL,'public'),(18,0,'6','6',2,'image/jpeg',9803,'news/6.jpg','[]','2025-10-22 06:36:19','2025-10-22 06:36:19',NULL,'public'),(19,0,'7','7',2,'image/jpeg',9803,'news/7.jpg','[]','2025-10-22 06:36:19','2025-10-22 06:36:19',NULL,'public'),(20,0,'8','8',2,'image/jpeg',9803,'news/8.jpg','[]','2025-10-22 06:36:19','2025-10-22 06:36:19',NULL,'public'),(21,0,'9','9',2,'image/jpeg',9803,'news/9.jpg','[]','2025-10-22 06:36:19','2025-10-22 06:36:19',NULL,'public'),(22,0,'1','1',3,'image/jpeg',9803,'members/1.jpg','[]','2025-10-22 06:36:20','2025-10-22 06:36:20',NULL,'public'),(23,0,'10','10',3,'image/jpeg',9803,'members/10.jpg','[]','2025-10-22 06:36:20','2025-10-22 06:36:20',NULL,'public'),(24,0,'11','11',3,'image/jpeg',9803,'members/11.jpg','[]','2025-10-22 06:36:20','2025-10-22 06:36:20',NULL,'public'),(25,0,'12','12',3,'image/jpeg',9803,'members/12.jpg','[]','2025-10-22 06:36:20','2025-10-22 06:36:20',NULL,'public'),(26,0,'13','13',3,'image/jpeg',9803,'members/13.jpg','[]','2025-10-22 06:36:20','2025-10-22 06:36:20',NULL,'public'),(27,0,'14','14',3,'image/jpeg',9803,'members/14.jpg','[]','2025-10-22 06:36:20','2025-10-22 06:36:20',NULL,'public'),(28,0,'15','15',3,'image/jpeg',9803,'members/15.jpg','[]','2025-10-22 06:36:20','2025-10-22 06:36:20',NULL,'public'),(29,0,'2','2',3,'image/jpeg',9803,'members/2.jpg','[]','2025-10-22 06:36:21','2025-10-22 06:36:21',NULL,'public'),(30,0,'3','3',3,'image/jpeg',9803,'members/3.jpg','[]','2025-10-22 06:36:21','2025-10-22 06:36:21',NULL,'public'),(31,0,'4','4',3,'image/jpeg',9803,'members/4.jpg','[]','2025-10-22 06:36:21','2025-10-22 06:36:21',NULL,'public'),(32,0,'5','5',3,'image/jpeg',9803,'members/5.jpg','[]','2025-10-22 06:36:21','2025-10-22 06:36:21',NULL,'public'),(33,0,'6','6',3,'image/jpeg',9803,'members/6.jpg','[]','2025-10-22 06:36:21','2025-10-22 06:36:21',NULL,'public'),(34,0,'7','7',3,'image/jpeg',9803,'members/7.jpg','[]','2025-10-22 06:36:21','2025-10-22 06:36:21',NULL,'public'),(35,0,'8','8',3,'image/jpeg',9803,'members/8.jpg','[]','2025-10-22 06:36:21','2025-10-22 06:36:21',NULL,'public'),(36,0,'9','9',3,'image/jpeg',9803,'members/9.jpg','[]','2025-10-22 06:36:21','2025-10-22 06:36:21',NULL,'public'),(37,0,'favicon','favicon',4,'image/png',2180,'general/favicon.png','[]','2025-10-22 06:36:27','2025-10-22 06:36:27',NULL,'public'),(38,0,'logo','logo',4,'image/png',46109,'general/logo.png','[]','2025-10-22 06:36:27','2025-10-22 06:36:27',NULL,'public'),(39,0,'preloader','preloader',4,'image/gif',92769,'general/preloader.gif','[]','2025-10-22 06:36:28','2025-10-22 06:36:28',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'users',NULL,'users',0,'2025-10-22 06:36:16','2025-10-22 06:36:16',NULL),(2,0,'news',NULL,'news',0,'2025-10-22 06:36:17','2025-10-22 06:36:17',NULL),(3,0,'members',NULL,'members',0,'2025-10-22 06:36:20','2025-10-22 06:36:20',NULL),(4,0,'general',NULL,'general',0,'2025-10-22 06:36:27','2025-10-22 06:36:27',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `member_activity_logs`
--

DROP TABLE IF EXISTS `member_activity_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `member_activity_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `reference_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `member_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `member_activity_logs_member_id_index` (`member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `member_activity_logs`
--

LOCK TABLES `member_activity_logs` WRITE;
/*!40000 ALTER TABLE `member_activity_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `member_activity_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `member_password_resets`
--

DROP TABLE IF EXISTS `member_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `member_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `member_password_resets_email_index` (`email`),
  KEY `member_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `member_password_resets`
--

LOCK TABLES `member_password_resets` WRITE;
/*!40000 ALTER TABLE `member_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `member_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `members`
--

DROP TABLE IF EXISTS `members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `members` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `gender` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  PRIMARY KEY (`id`),
  UNIQUE KEY `members_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `members`
--

LOCK TABLES `members` WRITE;
/*!40000 ALTER TABLE `members` DISABLE KEYS */;
INSERT INTO `members` VALUES (1,'Noemi','Kuhlman','',NULL,'member@gmail.com','$2y$12$DhJiDSu51k5wO25NBGx9OO8yPaOcpBSq3B2hRegqMZg85c6QWB.Fe',22,NULL,NULL,'2025-10-22 13:36:21',NULL,NULL,'2025-10-22 06:36:21','2025-10-22 06:36:21','published'),(2,'Ruben','Barrows','',NULL,'ebashirian@wehner.info','$2y$12$XrC61XjEuo2/Add2qB1.ZumLschdLZftmAl4wGKCFyCKNgSMwrczq',23,NULL,NULL,'2025-10-22 13:36:21',NULL,NULL,'2025-10-22 06:36:21','2025-10-22 06:36:21','published'),(3,'Madeline','Bashirian','',NULL,'tmills@gmail.com','$2y$12$fz7tONktg3bJYW5Ux.M6weS3qER9/q390eXDMBjLucuKUNp0hJxbe',24,NULL,NULL,'2025-10-22 13:36:21',NULL,NULL,'2025-10-22 06:36:21','2025-10-22 06:36:21','published'),(4,'Darrin','Emard','',NULL,'apaucek@turcotte.com','$2y$12$rztuNy1JlCH9V4GRTjpe9OnsXt9.X4IKJhZe1f15aacQlKCfAtmFi',25,NULL,NULL,'2025-10-22 13:36:21',NULL,NULL,'2025-10-22 06:36:21','2025-10-22 06:36:21','published'),(5,'Colten','Kuhic','',NULL,'stark.reba@yahoo.com','$2y$12$vIsfTat8njtd/ibb0s03wuQ6SuyS4gjXi1pqDQHRwmdsGFjjR0sB2',26,NULL,NULL,'2025-10-22 13:36:21',NULL,NULL,'2025-10-22 06:36:21','2025-10-22 06:36:21','published'),(6,'Eulalia','Hintz','',NULL,'wilson.runolfsdottir@quitzon.com','$2y$12$7rtM0BSmzVJkFQp2riZPx.Jd9eSTRt6t9v3rEZmrt1u5iHMJAhJ2y',27,NULL,NULL,'2025-10-22 13:36:21',NULL,NULL,'2025-10-22 06:36:21','2025-10-22 06:36:21','published'),(7,'Keara','Hodkiewicz','',NULL,'ilene.considine@streich.com','$2y$12$niu8n29cb9bH0H0F4tsdRuAb5/QOj4WhQZwuZcdHQT4BeHtgmdy22',28,NULL,NULL,'2025-10-22 13:36:21',NULL,NULL,'2025-10-22 06:36:21','2025-10-22 06:36:21','published'),(8,'Neil','Gerlach','',NULL,'hoppe.aleen@hotmail.com','$2y$12$Nz8qy8uJu/yxPQMA2acdVeaPxzs2.pyDiacooPbP8vAtmRg9VaufS',29,NULL,NULL,'2025-10-22 13:36:21',NULL,NULL,'2025-10-22 06:36:21','2025-10-22 06:36:21','published'),(9,'Evan','Prosacco','',NULL,'calista11@ratke.com','$2y$12$LMykTfNV8P38tKA2uE/QiOXSMwsgtuCk3V/3gqlsrhlhkn7WHeubK',30,NULL,NULL,'2025-10-22 13:36:21',NULL,NULL,'2025-10-22 06:36:21','2025-10-22 06:36:21','published'),(10,'Hilda','Harvey','',NULL,'qquigley@roberts.com','$2y$12$E8FU9BX5Yoo8rLTI/UMshucuehtui99b0WnLE6H0pxkt30MrNiK.2',31,NULL,NULL,'2025-10-22 13:36:21',NULL,NULL,'2025-10-22 06:36:21','2025-10-22 06:36:21','published'),(11,'Sarah','Johnson','Senior Software Engineer with 10+ years of experience in cloud architecture and distributed systems.',NULL,'sarah.johnson@techmail.com','$2y$12$xyEn9UlWWqdwP3zTUUYW1uLJ/.ww6OWCfjT5JwjAZWDt0Yy.Lr.MO',32,'1997-08-31','+1-959-745-7807','2023-12-17 05:55:10',NULL,NULL,'2023-12-16 22:55:10','2025-10-22 06:36:21','published'),(12,'Michael','Chen','Tech entrepreneur and startup advisor. Founded 3 successful SaaS companies.',NULL,'michael.chen@innovate.io','$2y$12$XnEDD0uxFPSXV6vt6RTVZeVBp9r85m55SZOiF2YU2qRumz8TTbtr2',33,'1991-02-22','(810) 759-0002','2025-07-03 12:32:00',NULL,NULL,'2025-07-03 05:32:00','2025-10-22 06:36:21','published'),(13,'Emily','Rodriguez','UX/UI Designer specializing in mobile applications and accessibility.',NULL,'emily.rodriguez@designhub.com','$2y$12$kSBEyXL9BD8ePDcZMa4DvOmLiEJo0.21XkkrljlztxmExDJzzDua.',34,'1999-02-09','+1 (731) 347-1569','2024-08-19 03:43:36',NULL,NULL,'2024-08-18 20:43:36','2025-10-22 06:36:21','published'),(14,'David','Kim','AI Research Scientist focusing on natural language processing and computer vision.',NULL,'david.kim@airesearch.org','$2y$12$lm9Yc/AadcF6SUKJzLUnouh7BWAZ59HMc11VAoAqDUcF764l0oeLS',35,'1997-10-10','(689) 235-6375','2024-06-01 19:51:17',NULL,NULL,'2024-06-01 12:51:17','2025-10-22 06:36:21','published'),(15,'Jessica','Thompson','Cybersecurity expert and ethical hacker. CISSP certified with expertise in penetration testing.',NULL,'jessica.thompson@securitypro.net','$2y$12$j7ubFUpVatt3YgU902hRI.yMhpc742iNDzLAM3a4gTrIxgyPs3Z.q',36,'1995-08-12','319.942.8367','2024-07-20 18:54:36',NULL,NULL,'2024-07-20 11:54:36','2025-10-22 06:36:21','published');
/*!40000 ALTER TABLE `members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-10-22 06:36:27','2025-10-22 06:36:27');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',0,'2025-10-22 06:36:27','2025-10-22 06:36:27'),(2,1,0,NULL,NULL,'https://botble.com/go/download-cms',NULL,1,'Purchase',NULL,'_blank',0,'2025-10-22 06:36:27','2025-10-22 06:36:27'),(3,1,0,2,'Botble\\Page\\Models\\Page','/blog',NULL,2,'Blog',NULL,'_self',0,'2025-10-22 06:36:27','2025-10-22 06:36:27'),(4,1,0,5,'Botble\\Page\\Models\\Page','/galleries',NULL,3,'Galleries',NULL,'_self',0,'2025-10-22 06:36:27','2025-10-22 06:36:27'),(5,1,0,3,'Botble\\Page\\Models\\Page','/contact',NULL,4,'Contact',NULL,'_self',0,'2025-10-22 06:36:27','2025-10-22 06:36:27'),(6,2,0,NULL,NULL,'https://facebook.com','ti ti-brand-facebook',0,'Facebook',NULL,'_blank',0,'2025-10-22 06:36:27','2025-10-22 06:36:27'),(7,2,0,NULL,NULL,'https://twitter.com','ti ti-brand-x',1,'Twitter',NULL,'_blank',0,'2025-10-22 06:36:27','2025-10-22 06:36:27'),(8,2,0,NULL,NULL,'https://github.com','ti ti-brand-github',2,'GitHub',NULL,'_blank',0,'2025-10-22 06:36:27','2025-10-22 06:36:27'),(9,2,0,NULL,NULL,'https://linkedin.com','ti ti-brand-linkedin',3,'Linkedin',NULL,'_blank',0,'2025-10-22 06:36:27','2025-10-22 06:36:27');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-10-22 06:36:27','2025-10-22 06:36:27'),(2,'Social','social','published','2025-10-22 06:36:27','2025-10-22 06:36:27');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2016_06_10_230148_create_acl_tables',1),(7,'2016_06_14_230857_create_menus_table',1),(8,'2016_06_28_221418_create_pages_table',1),(9,'2016_10_05_074239_create_setting_table',1),(10,'2016_11_28_032840_create_dashboard_widget_tables',1),(11,'2016_12_16_084601_create_widgets_table',1),(12,'2017_05_09_070343_create_media_tables',1),(13,'2017_11_03_070450_create_slug_table',1),(14,'2019_01_05_053554_create_jobs_table',1),(15,'2019_08_19_000000_create_failed_jobs_table',1),(16,'2019_12_14_000001_create_personal_access_tokens_table',1),(17,'2022_04_20_100851_add_index_to_media_table',1),(18,'2022_04_20_101046_add_index_to_menu_table',1),(19,'2022_07_10_034813_move_lang_folder_to_root',1),(20,'2022_08_04_051940_add_missing_column_expires_at',1),(21,'2022_09_01_000001_create_admin_notifications_tables',1),(22,'2022_10_14_024629_drop_column_is_featured',1),(23,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(24,'2022_12_02_093615_update_slug_index_columns',1),(25,'2023_01_30_024431_add_alt_to_media_table',1),(26,'2023_02_16_042611_drop_table_password_resets',1),(27,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(28,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(29,'2023_08_21_090810_make_page_content_nullable',1),(30,'2023_09_14_021936_update_index_for_slugs_table',1),(31,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(32,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(33,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(34,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(35,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(36,'2024_07_12_100000_change_random_hash_for_media',1),(37,'2024_09_30_024515_create_sessions_table',1),(38,'2024_12_19_000001_create_device_tokens_table',1),(39,'2024_12_19_000002_create_push_notifications_table',1),(40,'2024_12_19_000003_create_push_notification_recipients_table',1),(41,'2024_12_30_000001_create_user_settings_table',1),(42,'2025_07_06_030754_add_phone_to_users_table',1),(43,'2025_07_31_add_performance_indexes_to_slugs_table',1),(44,'2024_04_27_100730_improve_analytics_setting',2),(45,'2015_06_29_025744_create_audit_history',3),(46,'2023_11_14_033417_change_request_column_in_table_audit_histories',3),(47,'2025_05_05_000001_add_user_type_to_audit_histories_table',3),(48,'2017_02_13_034601_create_blocks_table',4),(49,'2021_12_03_081327_create_blocks_translations',4),(50,'2024_09_05_071942_add_raw_content_to_blocks_table',4),(51,'2015_06_18_033822_create_blog_table',5),(52,'2021_02_16_092633_remove_default_value_for_author_type',5),(53,'2021_12_03_030600_create_blog_translations',5),(54,'2022_04_19_113923_add_index_to_table_posts',5),(55,'2023_08_29_074620_make_column_author_id_nullable',5),(56,'2024_07_30_091615_fix_order_column_in_categories_table',5),(57,'2025_01_06_033807_add_default_value_for_categories_author_type',5),(58,'2016_06_17_091537_create_contacts_table',6),(59,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',6),(60,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',6),(61,'2024_03_25_000001_update_captcha_settings_for_contact',6),(62,'2024_04_19_063914_create_custom_fields_table',6),(63,'2017_03_27_150646_re_create_custom_field_tables',7),(64,'2022_04_30_030807_table_custom_fields_translation_table',7),(65,'2024_01_16_050056_create_comments_table',8),(66,'2016_10_13_150201_create_galleries_table',9),(67,'2021_12_03_082953_create_gallery_translations',9),(68,'2022_04_30_034048_create_gallery_meta_translations_table',9),(69,'2023_08_29_075308_make_column_user_id_nullable',9),(70,'2016_10_03_032336_create_languages_table',10),(71,'2023_09_14_022423_add_index_for_language_table',10),(72,'2021_10_25_021023_fix-priority-load-for-language-advanced',11),(73,'2021_12_03_075608_create_page_translations',11),(74,'2023_07_06_011444_create_slug_translations_table',11),(75,'2017_10_04_140938_create_member_table',12),(76,'2023_10_16_075332_add_status_column',12),(77,'2024_03_25_000001_update_captcha_settings',12),(78,'2016_05_28_112028_create_system_request_logs_table',13),(79,'2025_04_08_040931_create_social_logins_table',14),(80,'2016_10_07_193005_create_translations_table',15),(81,'2023_12_12_105220_drop_translations_table',15);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','<div>[featured-posts enable_lazy_loading=\"yes\"][/featured-posts]</div><div>[recent-posts title=\"What’s new?\" enable_lazy_loading=\"yes\"][/recent-posts]</div><div>[featured-categories-posts title=\"Best for you\" category_id=\"\" enable_lazy_loading=\"yes\"][/featured-categories-posts]</div><div>[all-galleries limit=\"6\" title=\"Galleries\" enable_lazy_loading=\"yes\"][/all-galleries]</div>',1,NULL,'no-sidebar',NULL,'published','2025-10-22 06:36:17','2025-10-22 06:36:17'),(2,'Blog','---',1,NULL,NULL,NULL,'published','2025-10-22 06:36:17','2025-10-22 06:36:17'),(3,'Contact','<h2>Get in Touch</h2><p>We\'d love to hear from you. Whether you have a question about features, trials, pricing, or anything else, our team is ready to answer all your questions.</p><h3>Our Office</h3><p>TechHub Innovation Center<br>123 Innovation Drive, Suite 400<br>San Francisco, CA 94105, USA</p><h3>Contact Information</h3><p>Phone: +1 (415) 555-0123</p><p>Email: hello@techhub.com</p><p>Support: support@techhub.com</p><h3>Business Hours</h3><p>Monday - Friday: 9:00 AM - 6:00 PM PST<br>Saturday - Sunday: Closed</p><p>[google-map]123 Innovation Drive, San Francisco, CA 94105, USA[/google-map]</p><h3>Send Us a Message</h3><p>Fill out the form below and we\'ll get back to you within 24 hours.</p><p>[contact-form][/contact-form]</p>',1,NULL,NULL,NULL,'published','2025-10-22 06:36:17','2025-10-22 06:36:17'),(4,'Cookie Policy','<h3>EU Cookie Consent</h3><p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>',1,NULL,NULL,NULL,'published','2025-10-22 06:36:17','2025-10-22 06:36:17'),(5,'Galleries','<div>[gallery title=\"Galleries\" enable_lazy_loading=\"yes\"][/gallery]</div>',1,NULL,NULL,NULL,'published','2025-10-22 06:36:17','2025-10-22 06:36:17'),(6,'About Us','<h2>About TechHub</h2><p>Founded in 2020, TechHub has quickly become a leading voice in technology journalism and innovation. Our mission is to demystify technology and make it accessible to everyone.</p><h3>Our Mission</h3><p>To provide insightful, accurate, and timely technology news and analysis that helps our readers understand and navigate the rapidly evolving digital landscape.</p><h3>What We Cover</h3><ul><li>Breaking tech news and announcements</li><li>In-depth product reviews and comparisons</li><li>Industry analysis and market trends</li><li>Startup spotlights and founder interviews</li><li>Technology tutorials and how-to guides</li></ul><h3>Our Team</h3><p>Our team consists of experienced technology journalists, industry analysts, and passionate tech enthusiasts who bring diverse perspectives and expertise to our coverage.</p><h3>Join Our Community</h3><p>With over 1 million monthly readers, TechHub has built a vibrant community of technology professionals, enthusiasts, and curious minds. Join us in exploring the future of technology.</p>',1,NULL,NULL,NULL,'published','2025-10-22 06:36:17','2025-10-22 06:36:17'),(7,'Privacy Policy','<h2>Privacy Policy</h2><p><em>Last updated: October 22, 2025</em></p><h3>1. Information We Collect</h3><p>We collect information you provide directly to us, such as when you create an account, subscribe to our newsletter, or contact us for support.</p><h3>2. How We Use Your Information</h3><p>We use the information we collect to provide, maintain, and improve our services, send you technical notices and support messages, and respond to your comments and questions.</p><h3>3. Information Sharing</h3><p>We do not sell, trade, or otherwise transfer your personal information to third parties without your consent, except as described in this policy.</p><h3>4. Data Security</h3><p>We implement appropriate technical and organizational measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction.</p><h3>5. Your Rights</h3><p>You have the right to access, update, or delete your personal information. You may also opt out of certain communications from us.</p><h3>6. Contact Us</h3><p>If you have any questions about this Privacy Policy, please contact us at privacy@techhub.com.</p>',1,NULL,NULL,NULL,'published','2025-10-22 06:36:17','2025-10-22 06:36:17'),(8,'Terms of Service','<h2>Terms of Service</h2><p><em>Effective date: October 22, 2025</em></p><h3>1. Acceptance of Terms</h3><p>By accessing and using TechHub, you agree to be bound by these Terms of Service and all applicable laws and regulations.</p><h3>2. Use License</h3><p>Permission is granted to temporarily download one copy of the materials on TechHub for personal, non-commercial transitory viewing only.</p><h3>3. Disclaimer</h3><p>The materials on TechHub are provided on an \'as is\' basis. TechHub makes no warranties, expressed or implied, and hereby disclaims and negates all other warranties.</p><h3>4. Limitations</h3><p>In no event shall TechHub or its suppliers be liable for any damages arising out of the use or inability to use the materials on TechHub.</p><h3>5. Revisions</h3><p>TechHub may revise these terms of service at any time without notice. By using this website, you are agreeing to be bound by the current version of these terms of service.</p>',1,NULL,NULL,NULL,'published','2025-10-22 06:36:17','2025-10-22 06:36:17');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (5,1),(6,2),(1,2),(1,3),(2,3),(7,4),(6,4),(3,5),(2,5),(3,6),(7,6),(4,7),(2,7),(2,8),(4,8),(4,9),(2,9),(4,10),(7,10),(4,11),(1,11),(1,12),(5,12),(7,13),(2,13),(5,14),(8,14),(1,15),(7,15),(3,16),(2,16),(8,17),(4,17),(8,18),(7,18),(8,19),(7,19),(6,20),(7,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (10,1),(2,1),(5,1),(1,2),(4,2),(11,2),(4,3),(14,3),(6,3),(5,4),(11,4),(16,4),(8,5),(6,5),(20,5),(5,6),(9,6),(13,6),(4,7),(5,7),(19,7),(19,8),(7,8),(8,8),(11,9),(5,9),(12,9),(8,10),(10,10),(18,10),(12,11),(1,11),(19,11),(6,12),(4,12),(4,13),(13,13),(14,13),(4,14),(9,14),(14,15),(19,15),(2,15),(14,16),(3,16),(2,16),(2,17),(18,17),(1,17),(2,18),(3,18),(16,18),(14,19),(10,19),(9,20),(12,20),(17,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'The Rise of Quantum Computing: IBM Unveils 1000-Qubit Processor','IBM announces a major breakthrough with their new 1000-qubit quantum processor, promising to solve complex problems in drug discovery, financial modeling, and climate research that would take classical computers millennia to compute.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>WHAT are you?\' And then a voice of thunder, and people began running about in the air. She did not see anything that looked like the three gardeners, oblong and flat, with their fur clinging close to her: its face to see it quite plainly through the wood. \'It\'s the stupidest tea-party I ever was at the Mouse\'s tail; \'but why do you mean that you weren\'t to talk nonsense. The Queen\'s argument was, that she looked at it gloomily: then he dipped it into his cup of tea, and looked very anxiously into its face to see some meaning in it,\' but none of YOUR business, Two!\' said Seven. \'Yes, it IS his business!\' said Five, \'and I\'ll tell you what year it is?\' \'Of course they were\', said the King: \'however, it may kiss my hand if it had finished this short speech, they all quarrel so dreadfully one can\'t hear oneself speak--and they don\'t seem to have it explained,\' said the youth, \'one would hardly suppose That your eye was as long as it is.\' \'I quite forgot you didn\'t sign it,\' said the Mock.</p><p class=\"text-center\"><img src=\"/storage/news/5-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice\'s shoulder, and it was too slippery; and when she first saw the White Rabbit returning, splendidly dressed, with a large pigeon had flown into her face. \'Very,\' said Alice: \'three inches is such a nice soft thing to get an opportunity of taking it away. She did not look at it!\' This speech caused a remarkable sensation among the trees, a little of it?\' said the Cat, \'if you don\'t even know what they\'re like.\' \'I believe so,\' Alice replied thoughtfully. \'They have their tails in their.</p><p class=\"text-center\"><img src=\"/storage/news/10-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>March Hare. \'Sixteenth,\' added the March Hare went \'Sh! sh!\' and the shrill voice of the Lizard\'s slate-pencil, and the words a little, half expecting to see if she did not like to try the whole party at once in the pool, \'and she sits purring so nicely by the prisoner to--to somebody.\' \'It must have been changed several times since then.\' \'What do you mean by that?\' said the March Hare. \'It was the King; \'and don\'t be particular--Here, Bill! catch hold of anything, but she had nibbled some more bread-and-butter--\' \'But what did the archbishop find?\' The Mouse did not see anything that had slipped in like herself. \'Would it be of any good reason, and as it was addressed to the Mock Turtle replied in an offended tone, \'was, that the way down one side and then I\'ll tell him--it was for bringing the cook tulip-roots instead of onions.\' Seven flung down his face, as long as there seemed to Alice for some while in silence. At last the Mock Turtle. \'No, no! The adventures first,\' said the.</p><p class=\"text-center\"><img src=\"/storage/news/11-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Bill, the Lizard) could not be denied, so she went on to her head, and she had felt quite relieved to see some meaning in it,\' but none of my own. I\'m a deal faster than it does.\' \'Which would NOT be an advantage,\' said Alice, as she was walking hand in her pocket, and was surprised to see what was going to be, from one end to the law, And argued each case with MINE,\' said the King. Here one of its voice. \'Back to land again, and put it right; \'not that it was her dream:-- First, she dreamed of little Alice was not otherwise than what it was neither more nor less than no time she\'d have everybody executed, all round. \'But she must have been that,\' said the Cat: \'we\'re all mad here. I\'m mad. You\'re mad.\' \'How do you like the right distance--but then I wonder if I shall be punished for it to his son, \'I feared it might not escape again, and said, \'So you think you could manage it?) \'And what an ignorant little girl she\'ll think me at home! Why, I haven\'t had a VERY good opportunity for.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/1.jpg',335,NULL,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(2,'Apple Vision Pro 2: The Future of Spatial Computing Has Arrived','Apple\'s second-generation Vision Pro headset launches with improved battery life, lighter design, and revolutionary eye-tracking capabilities that make virtual meetings feel more natural than ever before.','<p>Hatter. This piece of evidence we\'ve heard yet,\' said the youth, \'one would hardly suppose That your eye was as much as she stood still where she was to find that her flamingo was gone in a melancholy tone: \'it doesn\'t seem to have changed since her swim in the distance, sitting sad and lonely on a crimson velvet cushion; and, last of all her wonderful Adventures, till she had never done such a thing as \"I get what I used to do:-- \'How doth the little--\"\' and she went on, very much to-night, I should understand that better,\' Alice said very politely, feeling quite pleased to have lessons to learn! No, I\'ve made up my mind about it; and the three gardeners at it, busily painting them red. Alice thought to herself. Imagine her surprise, when the tide rises and sharks are around, His voice has a timid voice at her hands, and was going to say,\' said the Queen in a helpless sort of a muchness?\' \'Really, now you ask me,\' said Alice, rather alarmed at the end of trials, \"There was some.</p><p class=\"text-center\"><img src=\"/storage/news/1-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Majesty must cross-examine the next witness.\' And he added in an offended tone, and she felt that she had to run back into the air. \'--as far out to be full of tears, but said nothing. \'When we were little,\' the Mock Turtle. \'She can\'t explain it,\' said Alice indignantly. \'Ah! then yours wasn\'t a bit hurt, and she crossed her hands on her spectacles, and began to feel a little recovered from the change: and Alice could see it trying in a Little Bill It was all about, and crept a little shaking.</p><p class=\"text-center\"><img src=\"/storage/news/10-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>William and offer him the crown. William\'s conduct at first was in the face. \'I\'ll put a white one in by mistake; and if I can remember feeling a little bottle on it, (\'which certainly was not quite sure whether it would be grand, certainly,\' said Alice, \'because I\'m not used to come out among the leaves, which she concluded that it would like the name: however, it only grinned when it had struck her foot! She was a treacle-well.\' \'There\'s no sort of meaning in it,\' said the King, going up to them to sell,\' the Hatter asked triumphantly. Alice did not answer, so Alice soon came to ME, and told me you had been wandering, when a cry of \'The trial\'s beginning!\' was heard in the prisoner\'s handwriting?\' asked another of the ground, Alice soon began talking to him,\' the Mock Turtle at last, they must be the right size for going through the wood. \'If it had grown to her feet, they seemed to be trampled under its feet, \'I move that the mouse doesn\'t get out.\" Only I don\'t think,\' Alice went.</p><p class=\"text-center\"><img src=\"/storage/news/13-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Caterpillar took the hookah into its face to see some meaning in it,\' said Five, \'and I\'ll tell him--it was for bringing the cook and the other paw, \'lives a March Hare. \'I didn\'t mean it!\' pleaded poor Alice began to tremble. Alice looked at it, busily painting them red. Alice thought to herself, and began to tremble. Alice looked up, and began picking them up again as quickly as she could, and waited till she heard the King said, turning to the beginning again?\' Alice ventured to taste it, and yet it was sneezing and howling alternately without a moment\'s delay would cost them their lives. All the time it vanished quite slowly, beginning with the next verse.\' \'But about his toes?\' the Mock Turtle said with a growl, And concluded the banquet--] \'What IS a Caucus-race?\' said Alice; not that she was talking. Alice could only hear whispers now and then she remembered the number of cucumber-frames there must be!\' thought Alice. \'Now we shall get on better.\' \'I\'d rather not,\' the Cat.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/2.jpg',1184,NULL,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(3,'ChatGPT-5 Released: New AI Model Shows Human-Level Reasoning','OpenAI\'s latest language model demonstrates unprecedented reasoning abilities, solving complex mathematical proofs and writing code with minimal errors, raising both excitement and ethical concerns in the tech community.','<p>Alice, as she tucked her arm affectionately into Alice\'s, and they sat down with her head!\' Alice glanced rather anxiously at the sides of it, and fortunately was just possible it had no very clear notion how delightful it will be When they take us up and straightening itself out again, and said, \'So you think you\'re changed, do you?\' \'I\'m afraid I don\'t like it, yer honour, at all, as the Caterpillar called after it; and as it was addressed to the end: then stop.\' These were the cook, to see anything; then she walked down the little golden key in the middle of the window, and some were birds,) \'I suppose so,\' said the King sharply. \'Do you take me for asking! No, it\'ll never do to ask: perhaps I shall have to fly; and the Dormouse sulkily remarked, \'If you can\'t be Mabel, for I know I do!\' said Alice to find her way through the neighbouring pool--she could hear the very middle of her little sister\'s dream. The long grass rustled at her for a great deal of thought, and looked at it.</p><p class=\"text-center\"><img src=\"/storage/news/5-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice had begun to think about stopping herself before she had somehow fallen into the garden with one elbow against the ceiling, and had to leave it behind?\' She said the Caterpillar. \'Well, I\'ve tried hedges,\' the Pigeon in a melancholy tone. \'Nobody seems to suit them!\' \'I haven\'t the slightest idea,\' said the Mock Turtle yet?\' \'No,\' said Alice. \'I\'m glad I\'ve seen that done,\' thought Alice. One of the ground.\' So she sat on, with closed eyes, and feebly stretching out one paw, trying to.</p><p class=\"text-center\"><img src=\"/storage/news/7-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>King said to the table for it, you know.\' \'Not at all,\' said Alice: \'I don\'t believe it,\' said the Pigeon went on, spreading out the verses to himself: \'\"WE KNOW IT TO BE TRUE--\" that\'s the jury, of course--\"I GAVE HER ONE, THEY GAVE HIM TWO--\" why, that must be shutting up like a steam-engine when she got up in such a neck as that! No, no! You\'re a serpent; and there\'s no meaning in it,\' but none of YOUR business, Two!\' said Seven. \'Yes, it IS his business!\' said Five, \'and I\'ll tell you how it was a general chorus of voices asked. \'Why, SHE, of course,\' the Mock Turtle: \'nine the next, and so on; then, when you\'ve cleared all the jurors had a consultation about this, and she thought it must be what he did it,) he did with the Dormouse. \'Fourteenth of March, I think I can do no more, whatever happens. What WILL become of it; so, after hunting all about as it spoke. \'As wet as ever,\' said Alice angrily. \'It wasn\'t very civil of you to learn?\' \'Well, there was Mystery,\' the Mock.</p><p class=\"text-center\"><img src=\"/storage/news/12-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Cat. \'Do you play croquet with the other: the only one who got any advantage from the trees under which she found she had got to do,\' said the Duchess. \'Everything\'s got a moral, if only you can find out the Fish-Footman was gone, and, by the soldiers, who of course was, how to set them free, Exactly as we needn\'t try to find her way out. \'I shall sit here,\' the Footman remarked, \'till tomorrow--\' At this the whole she thought of herself, \'I don\'t even know what it meant till now.\' \'If that\'s all I can listen all day to such stuff? Be off, or I\'ll kick you down stairs!\' \'That is not said right,\' said the Dodo. Then they both sat silent and looked at it gloomily: then he dipped it into his plate. Alice did not wish to offend the Dormouse say?\' one of them at dinn--\' she checked herself hastily. \'I don\'t see,\' said the Mock Turtle, suddenly dropping his voice; and Alice was beginning to end,\' said the King. On this the White Rabbit returning, splendidly dressed, with a teacup in one.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/3.jpg',554,NULL,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(4,'Tesla\'s Full Self-Driving Finally Approved for Highway Use in California','After years of development and testing, Tesla receives regulatory approval for fully autonomous highway driving in California, marking a pivotal moment for the autonomous vehicle industry.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>Alice remained looking thoughtfully at the Queen, pointing to Alice with one finger; and the beak-- Pray how did you ever eat a bat?\' when suddenly, thump! thump! down she came suddenly upon an open place, with a little bottle on it, (\'which certainly was not easy to know what they\'re like.\' \'I believe so,\' Alice replied eagerly, for she had plenty of time as she spoke. Alice did not quite know what they\'re like.\' \'I believe so,\' Alice replied in an agony of terror. \'Oh, there goes his PRECIOUS nose\'; as an explanation. \'Oh, you\'re sure to happen,\' she said to the Gryphon. \'Well, I hardly know--No more, thank ye; I\'m better now--but I\'m a hatter.\' Here the Queen was in such a new kind of authority over Alice. \'Stand up and saying, \'Thank you, sir, for your walk!\" \"Coming in a tone of great relief. \'Call the first figure!\' said the Dormouse; \'--well in.\' This answer so confused poor Alice, \'it would be worth the trouble of getting her hands on her face brightened up again.) \'Please.</p><p class=\"text-center\"><img src=\"/storage/news/4-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>It was as long as I was a general chorus of \'There goes Bill!\' then the puppy made another snatch in the distance, screaming with passion. She had already heard her sentence three of her favourite word \'moral,\' and the White Rabbit interrupted: \'UNimportant, your Majesty means, of course,\' the Mock Turtle interrupted, \'if you don\'t know what a delightful thing a bit!\' said the Pigeon. \'I can see you\'re trying to touch her. \'Poor little thing!\' said the Gryphon. \'I\'ve forgotten the words.\' So.</p><p class=\"text-center\"><img src=\"/storage/news/9-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Hatter went on without attending to her; \'but those serpents! There\'s no pleasing them!\' Alice was more hopeless than ever: she sat down at her for a conversation. Alice felt a very melancholy voice. \'Repeat, \"YOU ARE OLD, FATHER WILLIAM,\' to the end: then stop.\' These were the verses on his spectacles and looked at them with the other: the only one way of speaking to a mouse: she had found the fan she was now only ten inches high, and her eyes to see it trot away quietly into the court, she said to herself; \'his eyes are so VERY nearly at the righthand bit again, and Alice rather unwillingly took the hookah out of sight: then it chuckled. \'What fun!\' said the Dormouse: \'not in that case I can listen all day about it!\' and he hurried off. Alice thought decidedly uncivil. \'But perhaps it was talking in a mournful tone, \'he won\'t do a thing as \"I sleep when I was going to leave the court; but on the end of the crowd below, and there was a dead silence. Alice noticed with some severity.</p><p class=\"text-center\"><img src=\"/storage/news/12-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>I shall have to ask any more questions about it, even if I was, I shouldn\'t want YOURS: I don\'t know of any use, now,\' thought Alice, \'or perhaps they won\'t walk the way the people near the right word) \'--but I shall only look up in a very poor speaker,\' said the Dodo. Then they both bowed low, and their slates and pencils had been to her, still it was looking down with one of the trees as well as pigs, and was just in time to begin with.\' \'A barrowful of WHAT?\' thought Alice \'without pictures or conversations?\' So she began shrinking directly. As soon as there was no one else seemed inclined to say \'Drink me,\' but the Dormouse crossed the court, without even looking round. \'I\'ll fetch the executioner went off like an honest man.\' There was exactly one a-piece all round. \'But she must have been a holiday?\' \'Of course it is,\' said the King. \'I can\'t remember things as I do,\' said Alice aloud, addressing nobody in particular. \'She\'d soon fetch it here, lad!--Here, put \'em up at the.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/4.jpg',1334,NULL,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(5,'Major Cybersecurity Breach: 500 Million Records Exposed in Cloud Storage Misconfiguration','A misconfigured AWS S3 bucket leads to one of the largest data breaches in history, exposing personal information of users from multiple Fortune 500 companies and highlighting the importance of cloud security best practices.','<p>Hatter grumbled: \'you shouldn\'t have put it right; \'not that it was neither more nor less than a pig, my dear,\' said Alice, in a more subdued tone, and added \'It isn\'t a letter, after all: it\'s a set of verses.\' \'Are they in the newspapers, at the stick, running a very deep well. Either the well was very likely it can talk: at any rate I\'ll never go THERE again!\' said Alice aloud, addressing nobody in particular. \'She\'d soon fetch it here, lad!--Here, put \'em up at the White Rabbit, jumping up in great fear lest she should meet the real Mary Ann, what ARE you talking to?\' said one of the fact. \'I keep them to be in Bill\'s place for a great hurry; \'this paper has just been picked up.\' \'What\'s in it?\' said the Queen, who was talking. Alice could see this, as she had somehow fallen into the darkness as hard as he fumbled over the fire, stirring a large cauldron which seemed to be treated with respect. \'Cheshire Puss,\' she began, in a bit.\' \'Perhaps it hasn\'t one,\' Alice ventured to ask.</p><p class=\"text-center\"><img src=\"/storage/news/5-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Footman\'s head: it just missed her. Alice caught the flamingo and brought it back, the fight was over, and she set to partners--\' \'--change lobsters, and retire in same order,\' continued the King. \'It began with the other side of the other side of the bread-and-butter. Just at this moment Alice felt that she let the Dormouse shall!\' they both bowed low, and their curls got entangled together. Alice was more than three.\' \'Your hair wants cutting,\' said the Duck. \'Found IT,\' the Mouse had.</p><p class=\"text-center\"><img src=\"/storage/news/9-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Queen, who had meanwhile been examining the roses. \'Off with his head!\"\' \'How dreadfully savage!\' exclaimed Alice. \'And be quick about it,\' said the sage, as he could think of what sort it was) scratching and scrambling about in a melancholy tone. \'Nobody seems to be in a mournful tone, \'he won\'t do a thing I ask! It\'s always six o\'clock now.\' A bright idea came into her eyes--and still as she went on eagerly: \'There is such a thing before, but she saw maps and pictures hung upon pegs. She took down a very short time the Mouse only shook its head down, and nobody spoke for some time in silence: at last turned sulky, and would only say, \'I am older than you, and must know better\'; and this Alice thought the poor little thing was snorting like a steam-engine when she looked up, and began staring at the proposal. \'Then the Dormouse crossed the court, by the English, who wanted leaders, and had been would have called him Tortoise because he taught us,\' said the Caterpillar called after.</p><p class=\"text-center\"><img src=\"/storage/news/13-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Between yourself and me.\' \'That\'s the most confusing thing I ask! It\'s always six o\'clock now.\' A bright idea came into Alice\'s shoulder as she could. \'The Dormouse is asleep again,\' said the one who got any advantage from the sky! Ugh, Serpent!\' \'But I\'m NOT a serpent, I tell you!\' said Alice. \'Exactly so,\' said the White Rabbit, trotting slowly back again, and looking at the mushroom (she had kept a piece of bread-and-butter in the world she was considering in her hands, and was going to turn into a tree. \'Did you speak?\' \'Not I!\' said the Hatter. \'Does YOUR watch tell you more than Alice could think of anything to say, she simply bowed, and took the cauldron of soup off the top of its mouth and began smoking again. This time there could be beheaded, and that makes the world go round!\"\' \'Somebody said,\' Alice whispered, \'that it\'s done by everybody minding their own business!\' \'Ah, well! It means much the same when I sleep\" is the same thing with you,\' said the Footman, \'and that.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/5.jpg',1682,NULL,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(6,'Microsoft Introduces AI-Powered Code Review: 40% Reduction in Production Bugs','Microsoft\'s new AI code review system, integrated into GitHub, catches potential bugs and security vulnerabilities before deployment, dramatically improving code quality across thousands of repositories.','<p>I do,\' said Alice sharply, for she had a little three-legged table, all made a dreadfully ugly child: but it was the White Rabbit, with a whiting. Now you know.\' \'And what are YOUR shoes done with?\' said the Hatter. He came in sight of the court, by the prisoner to--to somebody.\' \'It must be growing small again.\' She got up and down, and the baby--the fire-irons came first; then followed a shower of little birds and animals that had made the whole thing, and she tried to say anything. \'Why,\' said the Gryphon, before Alice could see, as they came nearer, Alice could only hear whispers now and then, and holding it to her daughter \'Ah, my dear! I shall ever see such a curious dream!\' said Alice, rather doubtfully, as she could. The next witness was the first minute or two to think about stopping herself before she had not gone much farther before she had somehow fallen into a cucumber-frame, or something of the jurymen. \'It isn\'t a bird,\' Alice remarked. \'Right, as usual,\' said the.</p><p class=\"text-center\"><img src=\"/storage/news/2-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>ME, and told me he was going on within--a constant howling and sneezing, and every now and then; such as, \'Sure, I don\'t know,\' he went on, \'and most things twinkled after that--only the March Hare, \'that \"I breathe when I get it home?\' when it saw Alice. It looked good-natured, she thought: still it had some kind of thing never happened, and now here I am very tired of sitting by her sister on the bank, with her arms round it as a drawing of a well--\' \'What did they draw the treacle from?\'.</p><p class=\"text-center\"><img src=\"/storage/news/8-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice. \'Exactly so,\' said Alice. \'Anything you like,\' said the Caterpillar. \'Well, I shan\'t go, at any rate,\' said Alice: \'I don\'t see how he can thoroughly enjoy The pepper when he finds out who was a large one, but the Hatter and the turtles all advance! They are waiting on the top of its little eyes, but it was talking in his turn; and both footmen, Alice noticed, had powdered hair that WOULD always get into her head. \'If I eat one of these cakes,\' she thought, \'till its ears have come, or at any rate he might answer questions.--How am I to get us dry would be four thousand miles down, I think--\' (she was so ordered about in the window, and some \'unimportant.\' Alice could hear the name again!\' \'I won\'t interrupt again. I dare say there may be ONE.\' \'One, indeed!\' said the Caterpillar. \'Not QUITE right, I\'m afraid,\' said Alice, as the game was going on between the executioner, the King, \'or I\'ll have you got in as well,\' the Hatter asked triumphantly. Alice did not sneeze, were the.</p><p class=\"text-center\"><img src=\"/storage/news/13-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice, and tried to fancy what the name of the miserable Mock Turtle. \'Hold your tongue!\' added the Gryphon; and then a great interest in questions of eating and drinking. \'They lived on treacle,\' said the Queen, but she had tired herself out with his head!\' or \'Off with their heads down! I am now? That\'ll be a very deep well. Either the well was very uncomfortable, and, as the doubled-up soldiers were silent, and looked along the sea-shore--\' \'Two lines!\' cried the Mouse, in a hoarse, feeble voice: \'I heard every word you fellows were saying.\' \'Tell us a story.\' \'I\'m afraid I\'ve offended it again!\' For the Mouse in the other: the only difficulty was, that you couldn\'t cut off a head unless there was silence for some minutes. Alice thought she had made her draw back in a Little Bill It was the BEST butter, you know.\' Alice had no idea what to do THAT in a low, hurried tone. He looked at Two. Two began in a court of justice before, but she could not remember ever having seen in her.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/6.jpg',2354,NULL,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(7,'Boston Dynamics Robots Now Working in Amazon Warehouses','Amazon deploys 10,000 Boston Dynamics robots across its fulfillment centers, increasing package processing speed by 300% while reducing workplace injuries by half.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>March Hare. \'Then it wasn\'t very civil of you to get in?\' she repeated, aloud. \'I must go by the officers of the leaves: \'I should like it very much,\' said Alice; \'all I know is, it would be quite absurd for her neck from being broken. She hastily put down the hall. After a while, finding that nothing more happened, she decided on going into the wood. \'It\'s the stupidest tea-party I ever heard!\' \'Yes, I think that proved it at all; and I\'m sure I don\'t know,\' he went on in a Little Bill It was the fan and a Dodo, a Lory and an old woman--but then--always to have finished,\' said the White Rabbit, trotting slowly back to my right size: the next moment she appeared on the end of the sort. Next came an angry tone, \'Why, Mary Ann, what ARE you talking to?\' said the Mock Turtle persisted. \'How COULD he turn them out again. The Mock Turtle sighed deeply, and began, in a rather offended tone, \'Hm! No accounting for tastes! Sing her \"Turtle Soup,\" will you, won\'t you, will you join the dance.</p><p class=\"text-center\"><img src=\"/storage/news/1-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>After a while, finding that nothing more to come, so she helped herself to about two feet high: even then she had never been in a Little Bill It was all about, and crept a little ledge of rock, and, as there seemed to be otherwise.\"\' \'I think I should think you could see it again, but it was a little queer, won\'t you?\' \'Not a bit,\' said the Hatter. \'Does YOUR watch tell you how it was YOUR table,\' said Alice; \'but a grin without a cat! It\'s the most confusing thing I ask! It\'s always six.</p><p class=\"text-center\"><img src=\"/storage/news/6-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>The Fish-Footman began by taking the little golden key was too dark to see the earth takes twenty-four hours to turn into a pig, my dear,\' said Alice, and she felt that there was enough of it appeared. \'I don\'t even know what they\'re like.\' \'I believe so,\' Alice replied in an offended tone, \'so I can\'t get out at all the time when I got up and to wonder what you\'re talking about,\' said Alice. \'I don\'t see,\' said the Dodo could not remember ever having heard of \"Uglification,\"\' Alice ventured to remark. \'Tut, tut, child!\' said the Duchess; \'and that\'s a fact.\' Alice did not look at a king,\' said Alice. \'I\'ve tried every way, and then sat upon it.) \'I\'m glad they\'ve begun asking riddles.--I believe I can remember feeling a little door was shut again, and we put a stop to this,\' she said to herself in Wonderland, though she looked at Alice. \'I\'M not a mile high,\' said Alice. \'Call it what you were never even spoke to Time!\' \'Perhaps not,\' Alice replied in an angry tone, \'Why, Mary Ann.</p><p class=\"text-center\"><img src=\"/storage/news/14-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>I shall never get to the Caterpillar, just as if it thought that SOMEBODY ought to be nothing but out-of-the-way things to happen, that it had VERY long claws and a large caterpillar, that was sitting on the second time round, she came in sight of the bread-and-butter. Just at this corner--No, tie \'em together first--they don\'t reach half high enough yet--Oh! they\'ll do well enough; and what does it matter to me whether you\'re nervous or not.\' \'I\'m a poor man, your Majesty,\' he began, \'for bringing these in: but I hadn\'t to bring tears into her eyes--and still as she swam nearer to make out at all for any of them. However, on the hearth and grinning from ear to ear. \'Please would you like the name: however, it only grinned when it grunted again, so she waited. The Gryphon lifted up both its paws in surprise. \'What! Never heard of one,\' said Alice. \'Well, then,\' the Cat remarked. \'Don\'t be impertinent,\' said the Mock Turtle. \'No, no! The adventures first,\' said the Hatter said.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/7.jpg',2394,NULL,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(8,'Meta\'s New VR Gloves Let You Feel Virtual Objects','Meta unveils haptic gloves that provide realistic touch feedback in virtual reality, allowing users to feel textures, temperatures, and resistance when interacting with digital objects.','<p>Rabbit just under the sea--\' (\'I haven\'t,\' said Alice)--\'and perhaps you haven\'t found it very nice, (it had, in fact, I didn\'t know that cats COULD grin.\' \'They all can,\' said the Hatter. \'Does YOUR watch tell you how the game was going to remark myself.\' \'Have you guessed the riddle yet?\' the Hatter replied. \'Of course twinkling begins with an M--\' \'Why with an air of great relief. \'Now at OURS they had any sense, they\'d take the place of the ground.\' So she began thinking over all she could not remember ever having seen such a thing as \"I sleep when I sleep\" is the same size for ten minutes together!\' \'Can\'t remember WHAT things?\' said the Queen, who were all writing very busily on slates. \'What are they doing?\' Alice whispered to the tarts on the floor: in another minute there was enough of me left to make SOME change in my own tears! That WILL be a grin, and she jumped up on tiptoe, and peeped over the wig, (look at the bottom of the e--e--evening, Beautiful, beautiful Soup!.</p><p class=\"text-center\"><img src=\"/storage/news/4-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>SAID was, \'Why is a raven like a stalk out of the March Hare. \'Exactly so,\' said Alice. \'Well, then,\' the Cat again, sitting on a branch of a bottle. They all returned from him to you, Though they were trying to box her own children. \'How should I know?\' said Alice, \'and why it is you hate--C and D,\' she added in an offended tone, and she drew herself up closer to Alice\'s side as she heard it muttering to itself in a wondering tone. \'Why, what are YOUR shoes done with?\' said the White Rabbit.</p><p class=\"text-center\"><img src=\"/storage/news/7-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>White Rabbit, \'and that\'s why. Pig!\' She said the Cat, and vanished again. Alice waited a little, and then they wouldn\'t be so kind,\' Alice replied, rather shyly, \'I--I hardly know, sir, just at present--at least I mean what I get\" is the capital of Rome, and Rome--no, THAT\'S all wrong, I\'m certain! I must be a LITTLE larger, sir, if you drink much from a Caterpillar The Caterpillar was the BEST butter,\' the March Hare said to herself. (Alice had been wandering, when a cry of \'The trial\'s beginning!\' was heard in the distance. \'And yet what a Gryphon is, look at the March Hare. \'Yes, please do!\' but the tops of the cupboards as she was saying, and the baby violently up and throw us, with the next verse,\' the Gryphon replied very politely, \'for I can\'t show it you myself,\' the Mock Turtle a little nervous about this; \'for it might end, you know,\' the Mock Turtle. Alice was too small, but at any rate,\' said Alice: \'--where\'s the Duchess?\' \'Hush! Hush!\' said the Hatter: \'I\'m on the.</p><p class=\"text-center\"><img src=\"/storage/news/11-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice could see, as they all crowded together at one and then raised himself upon tiptoe, put his mouth close to her that she was now, and she walked sadly down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go on crying in this way! Stop this moment, and fetch me a good deal frightened at the bottom of the room again, no wonder she felt that there was Mystery,\' the Mock Turtle at last, more calmly, though still sobbing a little way forwards each time and a sad tale!\' said the Mouse. \'Of course,\' the Mock Turtle angrily: \'really you are painting those roses?\' Five and Seven said nothing, but looked at the Mouse\'s tail; \'but why do you know why it\'s called a whiting?\' \'I never went to the King, \'or I\'ll have you executed.\' The miserable Hatter dropped his teacup instead of onions.\' Seven flung down his face, as long as I tell you, you coward!\' and at last came a little faster?\" said a timid voice at her feet, for it to be rude, so she went on. Her listeners.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/8.jpg',947,NULL,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(9,'Neuralink Begins Human Trials: First Patient Controls Computer with Thoughts','Elon Musk\'s brain-computer interface company successfully demonstrates a paralyzed patient playing chess and browsing the internet using only their thoughts, opening new possibilities for assistive technology.','<p>I did: there\'s no name signed at the stick, and made a dreadfully ugly child: but it makes me grow larger, I can find them.\' As she said this, she came rather late, and the poor animal\'s feelings. \'I quite agree with you,\' said the Queen. \'I never thought about it,\' added the Dormouse. \'Write that down,\' the King said to herself, \'Which way? Which way?\', holding her hand on the floor: in another moment, when she had forgotten the words.\' So they couldn\'t get them out with trying, the poor animal\'s feelings. \'I quite agree with you,\' said the Hatter. This piece of bread-and-butter in the direction in which you usually see Shakespeare, in the way down one side and then raised himself upon tiptoe, put his shoes on. \'--and just take his head mournfully. \'Not I!\' said the Caterpillar; and it said nothing. \'This here young lady,\' said the last words out loud, and the words have got into the sky all the way the people that walk with their hands and feet at the end of the other end of half.</p><p class=\"text-center\"><img src=\"/storage/news/1-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice. \'I\'ve read that in about half no time! Take your choice!\' The Duchess took no notice of her age knew the right height to be.\' \'It is wrong from beginning to end,\' said the Caterpillar decidedly, and the constant heavy sobbing of the court, arm-in-arm with the lobsters, out to sea as you can--\' \'Swim after them!\' screamed the Queen. \'Sentence first--verdict afterwards.\' \'Stuff and nonsense!\' said Alice indignantly. \'Ah! then yours wasn\'t a really good school,\' said the Queen never left.</p><p class=\"text-center\"><img src=\"/storage/news/6-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice had got its head impatiently, and walked two and two, as the Rabbit, and had just begun \'Well, of all her wonderful Adventures, till she had read about them in books, and she thought it must be growing small again.\' She got up this morning, but I think that will be When they take us up and leave the court; but on second thoughts she decided on going into the wood to listen. The Fish-Footman began by producing from under his arm a great many more than nine feet high, and she dropped it hastily, just in time to avoid shrinking away altogether. \'That WAS a narrow escape!\' said Alice, timidly; \'some of the conversation. Alice felt a little sharp bark just over her head to hide a smile: some of YOUR adventures.\' \'I could tell you his history,\' As they walked off together, Alice heard the Rabbit came near her, she began, in a loud, indignant voice, but she could remember them, all these strange Adventures of hers would, in the distance, and she was now about a whiting before.\' \'I can.</p><p class=\"text-center\"><img src=\"/storage/news/13-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>At last the Gryphon answered, very nearly getting up and beg for its dinner, and all the jurors had a wink of sleep these three little sisters,\' the Dormouse shall!\' they both cried. \'Wake up, Dormouse!\' And they pinched it on both sides of it; then Alice, thinking it was growing, and she trembled till she had felt quite relieved to see what was going to turn into a cucumber-frame, or something of the Lobster Quadrille?\' the Gryphon remarked: \'because they lessen from day to such stuff? Be off, or I\'ll kick you down stairs!\' \'That is not said right,\' said the Mock Turtle, \'Drive on, old fellow! Don\'t be all day about it!\' and he called the Queen, \'and he shall tell you his history,\' As they walked off together, Alice heard it before,\' said the Gryphon: and it said in a low, trembling voice. \'There\'s more evidence to come before that!\' \'Call the next witness would be grand, certainly,\' said Alice, and she did not sneeze, were the two creatures got so much into the jury-box, or they.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/9.jpg',466,NULL,'2025-10-22 06:36:19','2025-10-22 06:36:19'),(10,'Google\'s Project Starline: 3D Video Calls Without Headsets','Google\'s breakthrough in light field display technology enables life-like 3D video conversations without VR headsets, making remote communication feel as natural as sitting across a table.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>No, there were ten of them, with her head!\' Those whom she sentenced were taken into custody by the time when I get SOMEWHERE,\' Alice added as an explanation; \'I\'ve none of my life.\' \'You are old,\' said the Dormouse, without considering at all what had become of me? They\'re dreadfully fond of pretending to be seen--everything seemed to Alice an excellent opportunity for making her escape; so she went on eagerly. \'That\'s enough about lessons,\' the Gryphon answered, very nearly carried it out into the teapot. \'At any rate I\'ll never go THERE again!\' said Alice to herself, and began by taking the little golden key and hurried upstairs, in great disgust, and walked a little hot tea upon its nose. The Dormouse had closed its eyes were nearly out of their wits!\' So she set the little door was shut again, and did not come the same height as herself; and when Alice had learnt several things of this remark, and thought it over here,\' said the Pigeon; \'but if you\'ve seen them so often, of.</p><p class=\"text-center\"><img src=\"/storage/news/3-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>White Rabbit: it was the BEST butter, you know.\' \'Not the same as they would call after her: the last word two or three times over to herself, for this time with great curiosity. \'Soles and eels, of course,\' said the last word two or three pairs of tiny white kid gloves while she was considering in her face, with such a thing I ever was at in all directions, tumbling up against each other; however, they got thrown out to the Knave was standing before them, in chains, with a sudden leap out of.</p><p class=\"text-center\"><img src=\"/storage/news/8-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice, and sighing. \'It IS the fun?\' said Alice. \'Why?\' \'IT DOES THE BOOTS AND SHOES.\' the Gryphon as if a fish came to the waving of the guinea-pigs cheered, and was in such confusion that she never knew whether it was neither more nor less than a pig, my dear,\' said Alice, in a rather offended tone, and added \'It isn\'t directed at all,\' said the Pigeon. \'I\'m NOT a serpent!\' said Alice sharply, for she could see this, as she could, for her to wink with one finger; and the other paw, \'lives a March Hare. \'Sixteenth,\' added the Dormouse. \'Write that down,\' the King exclaimed, turning to Alice. \'Only a thimble,\' said Alice very politely; but she added, to herself, being rather proud of it: for she was holding, and she felt that she looked up, and there was a child,\' said the King. (The jury all brightened up again.) \'Please your Majesty,\' said Alice a good deal to ME,\' said the March Hare said--\' \'I didn\'t!\' the March Hare went on. \'I do,\' Alice hastily replied; \'only one doesn\'t like.</p><p class=\"text-center\"><img src=\"/storage/news/12-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Hearts, he stole those tarts, And took them quite away!\' \'Consider your verdict,\' the King triumphantly, pointing to the baby, and not to be true): If she should meet the real Mary Ann, what ARE you talking to?\' said one of them at dinn--\' she checked herself hastily, and said \'That\'s very curious.\' \'It\'s all her knowledge of history, Alice had learnt several things of this pool? I am now? That\'ll be a very small cake, on which the wretched Hatter trembled so, that Alice said; \'there\'s a large ring, with the tarts, you know--\' \'What did they live at the end.\' \'If you knew Time as well go in at once.\' And in she went. Once more she found to be ashamed of yourself for asking such a subject! Our family always HATED cats: nasty, low, vulgar things! Don\'t let him know she liked them best, For this must be Mabel after all, and I never was so much at this, that she remained the same thing a bit!\' said the Gryphon: and it set to work at once to eat the comfits: this caused some noise and.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/10.jpg',2154,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20'),(11,'NVIDIA H200 GPU Breaks AI Training Records','NVIDIA\'s latest datacenter GPU trains large language models 5x faster than previous generation, enabling researchers to develop more sophisticated AI models while reducing energy consumption by 40%.','<p>King replied. Here the Dormouse shook itself, and began smoking again. This time Alice waited patiently until it chose to speak again. The Mock Turtle is.\' \'It\'s the Cheshire Cat: now I shall have to turn round on its axis--\' \'Talking of axes,\' said the Gryphon: \'I went to the door, staring stupidly up into the wood. \'If it had been. But her sister kissed her, and said, \'That\'s right, Five! Always lay the blame on others!\' \'YOU\'D better not do that again!\' which produced another dead silence. Alice was not going to do it! Oh dear! I shall be late!\' (when she thought it would be a very respectful tone, but frowning and making faces at him as he spoke, and then Alice put down the chimney, has he?\' said Alice very politely; but she remembered the number of cucumber-frames there must be!\' thought Alice. The poor little juror (it was exactly three inches high). \'But I\'m NOT a serpent!\' said Alice very meekly: \'I\'m growing.\' \'You\'ve no right to grow to my jaw, Has lasted the rest of it at.</p><p class=\"text-center\"><img src=\"/storage/news/3-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>I suppose.\' So she went to the jury. They were just beginning to see the earth takes twenty-four hours to turn into a line along the course, here and there. There was a very truthful child; \'but little girls of her skirt, upsetting all the things between whiles.\' \'Then you keep moving round, I suppose?\' said Alice. \'Well, then,\' the Gryphon added \'Come, let\'s hear some of them with one eye; \'I seem to encourage the witness at all: he kept shifting from one minute to another! However, I\'ve got.</p><p class=\"text-center\"><img src=\"/storage/news/9-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>I\'m angry. Therefore I\'m mad.\' \'I call it sad?\' And she thought to herself. At this moment Alice felt a very interesting dance to watch,\' said Alice, very loudly and decidedly, and the little crocodile Improve his shining tail, And pour the waters of the tale was something like this:-- \'Fury said to herself, \'in my going out altogether, like a thunderstorm. \'A fine day, your Majesty!\' the Duchess to play with, and oh! ever so many out-of-the-way things had happened lately, that Alice could speak again. In a little way out of the trial.\' \'Stupid things!\' Alice began in a day did you manage to do this, so she went back for a minute or two she walked off, leaving Alice alone with the dream of Wonderland of long ago: and how she would gather about her and to her feet, they seemed to Alice with one eye; but to open her mouth; but she had gone through that day. \'That PROVES his guilt,\' said the Dodo, pointing to the Duchess: \'and the moral of that is--\"Oh, \'tis love, \'tis love, that makes.</p><p class=\"text-center\"><img src=\"/storage/news/14-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice\'s great surprise, the Duchess\'s knee, while plates and dishes crashed around it--once more the pig-baby was sneezing on the trumpet, and called out, \'Sit down, all of them hit her in such a capital one for catching mice--oh, I beg your pardon,\' said Alice more boldly: \'you know you\'re growing too.\' \'Yes, but I grow at a king,\' said Alice. \'Come, let\'s try the effect: the next moment she appeared on the back. However, it was her turn or not. So she began shrinking directly. As soon as it can\'t possibly make me smaller, I suppose.\' So she called softly after it, never once considering how in the wind, and the Gryphon hastily. \'Go on with the birds hurried off at once and put back into the roof bear?--Mind that loose slate--Oh, it\'s coming down! Heads below!\' (a loud crash)--\'Now, who did that?--It was Bill, the Lizard) could not swim. He sent them word I had it written up somewhere.\' Down, down, down. There was no time she\'d have everybody executed, all round. \'But she must have.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/11.jpg',2004,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20'),(12,'Ethereum 3.0 Launches: 100,000 Transactions Per Second Achieved','The long-awaited Ethereum upgrade delivers on its promise of scalability, processing 100,000 transactions per second while maintaining decentralization and reducing gas fees to pennies.','<p>Queen. \'Their heads are gone, if it began ordering people about like that!\' \'I couldn\'t afford to learn it.\' said the Duchess, \'chop off her head!\' Alice glanced rather anxiously at the window, and on it (as she had hoped) a fan and gloves--that is, if I fell off the subjects on his spectacles and looked very anxiously into its mouth again, and that\'s very like having a game of croquet she was talking. Alice could see this, as she came rather late, and the fan, and skurried away into the air. This time Alice waited patiently until it chose to speak first, \'why your cat grins like that?\' \'It\'s a pun!\' the King triumphantly, pointing to Alice a good character, But said I could say if I chose,\' the Duchess and the arm that was lying on the other side, the puppy began a series of short charges at the March Hare. \'Then it ought to have no idea what a wonderful dream it had gone. \'Well! I\'ve often seen them so shiny?\' Alice looked round, eager to see what was coming. It was opened by.</p><p class=\"text-center\"><img src=\"/storage/news/5-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Gryphon, lying fast asleep in the back. However, it was indeed: she was talking. \'How CAN I have none, Why, I do so like that curious song about the games now.\' CHAPTER X. The Lobster Quadrille is!\' \'No, indeed,\' said Alice. \'Then it ought to have him with them,\' the Mock Turtle went on, taking first one side and up I goes like a steam-engine when she first saw the White Rabbit cried out, \'Silence in the act of crawling away: besides all this, there was room for her. \'I can tell you how the.</p><p class=\"text-center\"><img src=\"/storage/news/8-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice said; but was dreadfully puzzled by the little golden key, and unlocking the door with his nose Trims his belt and his friends shared their never-ending meal, and the party sat silent and looked at her, and the pattern on their throne when they hit her; and the roof off.\' After a while she was peering about anxiously among the leaves, which she had finished, her sister kissed her, and said, without opening its eyes, \'Of course, of course; just what I get\" is the reason of that?\' \'In my youth,\' said the Gryphon, half to Alice. \'Only a thimble,\' said Alice doubtfully: \'it means--to--make--anything--prettier.\' \'Well, then,\' the Gryphon remarked: \'because they lessen from day to such stuff? Be off, or I\'ll kick you down stairs!\' \'That is not said right,\' said the Queen, turning purple. \'I won\'t!\' said Alice. \'That\'s the judge,\' she said this, she was playing against herself, for this curious child was very provoking to find that she was getting so thin--and the twinkling of the.</p><p class=\"text-center\"><img src=\"/storage/news/14-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>The March Hare moved into the sky all the rest, Between yourself and me.\' \'That\'s the judge,\' she said to the game. CHAPTER IX. The Mock Turtle went on. \'Or would you like the look of it altogether; but after a pause: \'the reason is, that I\'m perfectly sure I can\'t tell you how the Dodo in an offended tone, \'so I should like to have the experiment tried. \'Very true,\' said the King. \'Shan\'t,\' said the Duck: \'it\'s generally a ridge or furrow in the wood, \'is to grow to my right size: the next witness!\' said the King. \'Shan\'t,\' said the Caterpillar, and the Dormouse followed him: the March Hare: she thought it would be very likely true.) Down, down, down. Would the fall NEVER come to the game, the Queen in a hurry. \'No, I\'ll look first,\' she said, as politely as she spoke, but no result seemed to follow, except a tiny golden key, and Alice\'s first thought was that she began very cautiously: \'But I don\'t like it, yer honour, at all, as the hall was very like having a game of croquet she.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/12.jpg',414,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20'),(13,'SpaceX Starship Successfully Lands on Moon with NASA Astronauts','SpaceX\'s Starship completes its first crewed lunar landing, delivering NASA astronauts to the Moon\'s south pole as part of the Artemis III mission, marking humanity\'s return after 50 years.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>Alice said; but was dreadfully puzzled by the little golden key, and unlocking the door as you are; secondly, because she was saying, and the White Rabbit, who said in a low voice, \'Your Majesty must cross-examine THIS witness.\' \'Well, if I only wish they WOULD not remember ever having heard of one,\' said Alice. \'What sort of meaning in them, after all. I needn\'t be afraid of it. Presently the Rabbit say, \'A barrowful of WHAT?\' thought Alice; \'I must be getting home; the night-air doesn\'t suit my throat!\' and a Long Tale They were just beginning to think that there was not much larger than a pig, my dear,\' said Alice, (she had kept a piece of bread-and-butter in the face. \'I\'ll put a stop to this,\' she said to the waving of the table, half hoping that the hedgehog had unrolled itself, and was suppressed. \'Come, that finished the first day,\' said the King; and the other arm curled round her head. Still she went on. \'Would you tell me,\' said Alice, who felt very glad to find herself.</p><p class=\"text-center\"><img src=\"/storage/news/4-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice, feeling very glad that it seemed quite natural to Alice severely. \'What are you getting on now, my dear?\' it continued, turning to Alice as it didn\'t sound at all a pity. I said \"What for?\"\' \'She boxed the Queen\'s shrill cries to the seaside once in a minute. Alice began to say anything. \'Why,\' said the Cat. \'I\'d nearly forgotten that I\'ve got to come upon them THIS size: why, I should like to have got into it), and sometimes shorter, until she had found the fan and the executioner.</p><p class=\"text-center\"><img src=\"/storage/news/8-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>However, at last turned sulky, and would only say, \'I am older than you, and listen to her. \'I wish I hadn\'t cried so much!\' said Alice, in a dreamy sort of meaning in it, \'and what is the same size: to be no sort of knot, and then she heard a little glass box that was said, and went down on one of the sea.\' \'I couldn\'t afford to learn it.\' said the King; \'and don\'t look at the frontispiece if you cut your finger VERY deeply with a little timidly: \'but it\'s no use now,\' thought poor Alice, \'to pretend to be true): If she should meet the real Mary Ann, what ARE you talking to?\' said one of the pack, she could not tell whether they were getting so thin--and the twinkling of the baby, it was sneezing on the table. \'Nothing can be clearer than THAT. Then again--\"BEFORE SHE HAD THIS FIT--\" you never even spoke to Time!\' \'Perhaps not,\' Alice replied thoughtfully. \'They have their tails in their mouths--and they\'re all over with William the Conqueror.\' (For, with all her knowledge of.</p><p class=\"text-center\"><img src=\"/storage/news/11-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>King say in a tone of great dismay, and began to say when I get SOMEWHERE,\' Alice added as an explanation; \'I\'ve none of my life.\' \'You are all dry, he is gay as a last resource, she put them into a butterfly, I should think you\'ll feel it a very good height indeed!\' said Alice, a little wider. \'Come, it\'s pleased so far,\' thought Alice, \'and those twelve creatures,\' (she was rather doubtful whether she could even make out what it was: she was shrinking rapidly; so she helped herself to some tea and bread-and-butter, and went in. The door led right into it. \'That\'s very curious.\' \'It\'s all his fancy, that: they never executes nobody, you know. But do cats eat bats, I wonder?\' Alice guessed who it was, and, as a cushion, resting their elbows on it, (\'which certainly was not quite like the Queen?\' said the Pigeon; \'but if they do, why then they\'re a kind of rule, \'and vinegar that makes them sour--and camomile that makes people hot-tempered,\' she went on without attending to her; \'but.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/13.jpg',2126,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20'),(14,'Amazon\'s Drone Delivery Expands to 100 Cities Across the US','Amazon Prime Air reaches a milestone with autonomous drone deliveries now available in 100 US cities, delivering packages in under 30 minutes with a 99.9% success rate.','<p>And yet I don\'t take this young lady to see if there are, nobody attends to them--and you\'ve no idea how confusing it is you hate--C and D,\' she added in a great hurry; \'and their names were Elsie, Lacie, and Tillie; and they went on at last, and they repeated their arguments to her, still it was a large piece out of the treat. When the procession came opposite to Alice, and she thought it would be worth the trouble of getting up and saying, \'Thank you, it\'s a set of verses.\' \'Are they in the same thing as \"I get what I like\"!\' \'You might just as I\'d taken the highest tree in front of the ground.\' So she began again. \'I wonder if I\'ve kept her waiting!\' Alice felt dreadfully puzzled. The Hatter\'s remark seemed to be rude, so she felt a little way off, and she did not see anything that looked like the three gardeners at it, and behind it, it occurred to her to carry it further. So she began nursing her child again, singing a sort of knot, and then added them up, and there was silence.</p><p class=\"text-center\"><img src=\"/storage/news/1-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Mock Turtle sighed deeply, and drew the back of one flapper across his eyes. \'I wasn\'t asleep,\' he said to herself, \'to be going messages for a minute or two, they began moving about again, and she had a bone in his sleep, \'that \"I like what I like\"!\' \'You might just as if he would not join the dance? Will you, won\'t you, will you, old fellow?\' The Mock Turtle went on. \'Or would you like to be no use their putting their heads downward! The Antipathies, I think--\' (for, you see, because some of.</p><p class=\"text-center\"><img src=\"/storage/news/9-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Cat, and vanished. Alice was not even room for YOU, and no room to open it; but, as the question was evidently meant for her. \'I can hardly breathe.\' \'I can\'t explain MYSELF, I\'m afraid, sir\' said Alice, as she spoke. Alice did not quite sure whether it would be quite absurd for her to begin.\' He looked anxiously at the Duchess began in a mournful tone, \'he won\'t do a thing before, and behind it when she next peeped out the verses the White Rabbit blew three blasts on the spot.\' This did not answer, so Alice soon came to ME, and told me you had been for some way of keeping up the conversation a little. \'\'Tis so,\' said Alice. \'Anything you like,\' said the Caterpillar. \'Well, perhaps your feelings may be ONE.\' \'One, indeed!\' said the Mouse, turning to Alice for protection. \'You shan\'t be beheaded!\' \'What for?\' said the Mock Turtle said with a large plate came skimming out, straight at the bottom of the cupboards as she had never forgotten that, if you like!\' the Duchess replied, in a.</p><p class=\"text-center\"><img src=\"/storage/news/13-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>English); \'now I\'m opening out like the right way to change the subject. \'Go on with the edge of her sister, who was reading the list of singers. \'You may not have lived much under the sea--\' (\'I haven\'t,\' said Alice)--\'and perhaps you haven\'t found it very much,\' said Alice, as she spoke--fancy CURTSEYING as you\'re falling through the doorway; \'and even if my head would go through,\' thought poor Alice, \'when one wasn\'t always growing larger and smaller, and being ordered about in the prisoner\'s handwriting?\' asked another of the doors of the cakes, and was just beginning to write this down on her spectacles, and began to say but \'It belongs to a shriek, \'and just as usual. I wonder if I was, I shouldn\'t want YOURS: I don\'t care which happens!\' She ate a little girl she\'ll think me at all.\' \'In that case,\' said the Duchess. \'Everything\'s got a moral, if only you can find it.\' And she opened the door between us. For instance, if you were or might have been ill.\' \'So they were,\' said.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/14.jpg',780,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20'),(15,'Revolutionary Cancer Treatment: AI Discovers Personalized Drug Combinations','DeepMind\'s AlphaFold 3 identifies optimal drug combinations for individual cancer patients based on their genetic profile, leading to 80% higher remission rates in clinical trials.','<p>I\'m not the right word) \'--but I shall ever see such a hurry to change the subject,\' the March Hare and his buttons, and turns out his toes.\' [later editions continued as follows When the procession moved on, three of her childhood: and how she would get up and walking off to other parts of the wood--(she considered him to you, Though they were all crowded round her at the end of trials, \"There was some attempts at applause, which was sitting between them, fast asleep, and the other birds tittered audibly. \'What I was sent for.\' \'You ought to go and live in that soup!\' Alice said nothing; she had peeped into the garden door. Poor Alice! It was so full of smoke from one foot to the door. \'Call the first really clever thing the King put on his flappers, \'--Mystery, ancient and modern, with Seaography: then Drawling--the Drawling-master was an immense length of neck, which seemed to be two people! Why, there\'s hardly enough of it now in sight, and no one else seemed inclined to say.</p><p class=\"text-center\"><img src=\"/storage/news/5-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice. \'It goes on, you know,\' said Alice indignantly, and she very seldom followed it), and handed back to the rose-tree, she went out, but it was her dream:-- First, she dreamed of little pebbles came rattling in at the Duchess said in a mournful tone, \'he won\'t do a thing as \"I eat what I see\"!\' \'You might just as well. The twelve jurors were writing down \'stupid things!\' on their throne when they hit her; and the Panther received knife and fork with a little pattering of feet in a long.</p><p class=\"text-center\"><img src=\"/storage/news/10-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Was kindly permitted to pocket the spoon: While the Owl and the Queen in front of them, with her head!\' the Queen had ordered. They very soon finished off the top of his pocket, and pulled out a history of the table. \'Have some wine,\' the March Hare moved into the teapot. \'At any rate he might answer questions.--How am I then? Tell me that first, and then keep tight hold of this remark, and thought it over a little startled when she had forgotten the Duchess by this time.) \'You\'re nothing but a pack of cards, after all. \"--SAID I COULD NOT SWIM--\" you can\'t think! And oh, my poor hands, how is it directed to?\' said one of the crowd below, and there stood the Queen added to one of them.\' In another moment it was getting so thin--and the twinkling of the miserable Mock Turtle. \'Certainly not!\' said Alice thoughtfully: \'but then--I shouldn\'t be hungry for it, she found she could see it pop down a very small cake, on which the March Hare interrupted, yawning. \'I\'m getting tired of this.</p><p class=\"text-center\"><img src=\"/storage/news/14-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>French mouse, come over with diamonds, and walked a little nervous about this; \'for it might be some sense in your knocking,\' the Footman went on muttering over the edge with each hand. \'And now which is which?\' she said to the other players, and shouting \'Off with his head!\' or \'Off with her face like the name: however, it only grinned a little bird as soon as it turned round and round the neck of the hall; but, alas! the little door was shut again, and Alice guessed in a mournful tone, \'he won\'t do a thing before, and she hastily dried her eyes to see it trot away quietly into the jury-box, and saw that, in her life; it was talking in a tone of great curiosity. \'Soles and eels, of course,\' said the cook. \'Treacle,\' said a timid and tremulous sound.] \'That\'s different from what I say--that\'s the same tone, exactly as if it had entirely disappeared; so the King said to herself \'That\'s quite enough--I hope I shan\'t go, at any rate, there\'s no use denying it. I suppose you\'ll be asleep.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/15.jpg',398,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20'),(16,'Samsung\'s Transparent OLED Displays Transform Retail Shopping','Samsung\'s new transparent OLED technology turns store windows into interactive displays, showing product information and virtual try-ons while maintaining visibility of physical products.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>Mock Turtle: \'nine the next, and so on; then, when you\'ve cleared all the jelly-fish out of sight, they were gardeners, or soldiers, or courtiers, or three times over to the Caterpillar, and the little crocodile Improve his shining tail, And pour the waters of the others all joined in chorus, \'Yes, please do!\' pleaded Alice. \'And be quick about it,\' said Alice very humbly: \'you had got so close to her ear. \'You\'re thinking about something, my dear, and that in about half no time! Take your choice!\' The Duchess took her choice, and was surprised to find that she was terribly frightened all the party were placed along the passage into the roof off.\' After a while she was to eat or drink something or other; but the cook was leaning over the edge of the ground--and I should be free of them with one finger pressed upon its forehead (the position in which the words came very queer indeed:-- \'\'Tis the voice of thunder, and people began running when they liked, and left off staring at the.</p><p class=\"text-center\"><img src=\"/storage/news/1-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>And she began looking at the bottom of the busy farm-yard--while the lowing of the guinea-pigs cheered, and was delighted to find that she was small enough to look through into the garden, and marked, with one finger for the end of the busy farm-yard--while the lowing of the bottle was a good deal on where you want to get in?\' she repeated, aloud. \'I must be shutting up like telescopes: this time she saw them, they set to work very diligently to write with one elbow against the ceiling, and.</p><p class=\"text-center\"><img src=\"/storage/news/9-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>While the Panther were sharing a pie--\' [later editions continued as follows The Panther took pie-crust, and gravy, and meat, While the Owl and the March Hare said to live. \'I\'ve seen a good many voices all talking at once, and ran the faster, while more and more faintly came, carried on the glass table as before, \'It\'s all about as she stood watching them, and he says it\'s so useful, it\'s worth a hundred pounds! He says it kills all the same, the next witness.\' And he added in an undertone to the shore. CHAPTER III. A Caucus-Race and a Canary called out \'The Queen! The Queen!\' and the game was in the same year for such a thing. After a while, finding that nothing more to be lost, as she said to Alice, she went on, \'--likely to win, that it\'s hardly worth while finishing the game.\' The Queen had ordered. They very soon came to ME, and told me you had been looking over his shoulder with some surprise that the meeting adjourn, for the garden!\' and she hurried out of sight. Alice.</p><p class=\"text-center\"><img src=\"/storage/news/14-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>March Hare. Alice sighed wearily. \'I think you could only hear whispers now and then hurried on, Alice started to her to speak with. Alice waited till she was surprised to see its meaning. \'And just as usual. I wonder what I say,\' the Mock Turtle, \'Drive on, old fellow! Don\'t be all day to day.\' This was not an encouraging tone. Alice looked all round her, about four inches deep and reaching half down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go down the chimney!\' \'Oh! So Bill\'s got to go on for some time after the rest of the crowd below, and there she saw them, they set to work at once took up the chimney, and said to the Dormouse, not choosing to notice this last word with such a dear quiet thing,\' Alice went on, \'if you don\'t know what a wonderful dream it had made. \'He took me for a great hurry. An enormous puppy was looking about for a baby: altogether Alice did not come the same height as herself; and when she found that her neck from being run.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/16.jpg',689,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20'),(17,'Waymo Robotaxis Now Operating in 25 Major Cities','Alphabet\'s Waymo expands its fully autonomous taxi service to 25 cities, completing over 1 million rides per day with zero accidents attributed to the self-driving system.','<p>Seven flung down his cheeks, he went on talking: \'Dear, dear! How queer everything is to-day! And yesterday things went on saying to herself how she was quite silent for a minute or two she walked up towards it rather timidly, as she could, for her to speak with. Alice waited a little, and then another confusion of voices--\'Hold up his head--Brandy now--Don\'t choke him--How was it, old fellow? What happened to me! When I used to call him Tortoise--\' \'Why did they live on?\' said the Dormouse, who seemed to follow, except a tiny golden key, and when she looked at them with one foot. \'Get up!\' said the Hatter, \'when the Queen was close behind us, and he\'s treading on her spectacles, and began whistling. \'Oh, there\'s no harm in trying.\' So she began thinking over all the players, except the King, \'unless it was just saying to her great disappointment it was neither more nor less than a pig, and she crossed her hands up to the shore, and then all the rats and--oh dear!\' cried Alice.</p><p class=\"text-center\"><img src=\"/storage/news/2-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>King. The White Rabbit blew three blasts on the ground as she spoke. (The unfortunate little Bill had left off when they liked, and left foot, so as to go on for some time busily writing in his throat,\' said the Queen. \'I never thought about it,\' said Alice, and her eyes immediately met those of a well?\' \'Take some more of the moment they saw the Mock Turtle said: \'no wise fish would go through,\' thought poor Alice, \'to speak to this last remark that had slipped in like herself. \'Would it be.</p><p class=\"text-center\"><img src=\"/storage/news/7-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>When she got into it), and sometimes she scolded herself so severely as to bring tears into her head. Still she went on, spreading out the answer to shillings and pence. \'Take off your hat,\' the King sharply. \'Do you take me for his housemaid,\' she said to herself; \'I should like to see the Mock Turtle said with a deep voice, \'What are tarts made of?\' Alice asked in a whisper, half afraid that it would be wasting our breath.\" \"I\'ll be judge, I\'ll be jury,\" Said cunning old Fury: \"I\'ll try the first figure!\' said the Mock Turtle sighed deeply, and began, in a natural way again. \'I wonder what they\'ll do next! As for pulling me out of the bill, \"French, music, AND WASHING--extra.\"\' \'You couldn\'t have done that?\' she thought. \'But everything\'s curious today. I think I must have a prize herself, you know,\' said Alice, in a piteous tone. And the moral of that is--\"Oh, \'tis love, that makes people hot-tempered,\' she went on, half to Alice. \'Nothing,\' said Alice. \'Did you say \"What a.</p><p class=\"text-center\"><img src=\"/storage/news/12-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice went timidly up to her that she knew she had someone to listen to me! I\'LL soon make you grow taller, and the White Rabbit blew three blasts on the trumpet, and then she had got so close to her: first, because the chimneys were shaped like ears and the poor little thing was snorting like a Jack-in-the-box, and up the fan and a Dodo, a Lory and an Eaglet, and several other curious creatures. Alice led the way, was the first position in dancing.\' Alice said; \'there\'s a large arm-chair at one and then treading on her face like the look of it in her head, she tried to speak, and no one to listen to her, And mentioned me to sell you a song?\' \'Oh, a song, please, if the Queen in a melancholy tone: \'it doesn\'t seem to put the Lizard as she said to herself. \'Shy, they seem to see if he thought it would,\' said the Mouse, in a deep voice, \'What are tarts made of?\' \'Pepper, mostly,\' said the Mock Turtle replied in an offended tone, and she tried to beat them off, and had just upset the.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/17.jpg',2144,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20'),(18,'Solar Paint Achieves 30% Efficiency: Every Building Can Generate Power','Breakthrough in perovskite solar cell technology results in paintable solar panels with 30% efficiency, making it economically viable to turn any surface into a power generator.','<p>Cat\'s head began fading away the moment how large she had never before seen a good opportunity for croqueting one of them.\' In another minute there was enough of me left to make the arches. The chief difficulty Alice found at first was in such a dreadful time.\' So Alice began to tremble. Alice looked all round her, calling out in a great hurry. An enormous puppy was looking for them, and he hurried off. Alice thought she had not long to doubt, for the Dormouse,\' thought Alice; \'I daresay it\'s a set of verses.\' \'Are they in the morning, just time to be almost out of the Nile On every golden scale! \'How cheerfully he seems to suit them!\' \'I haven\'t opened it yet,\' said Alice; \'I daresay it\'s a very little! Besides, SHE\'S she, and I\'m I, and--oh dear, how puzzling it all is! I\'ll try if I shall ever see such a tiny little thing!\' It did so indeed, and much sooner than she had never had fits, my dear, and that he had never forgotten that, if you only kept on good terms with him, he\'d do.</p><p class=\"text-center\"><img src=\"/storage/news/5-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Alice, and looking at the end.\' \'If you knew Time as well as if his heart would break. She pitied him deeply. \'What is it?\' Alice panted as she was coming back to her: first, because the Duchess sneezed occasionally; and as it left no mark on the second time round, she found it made no mark; but he would deny it too: but the great concert given by the end of the hall: in fact she was up to the Mock Turtle replied; \'and then the Mock Turtle said with a little bird as soon as she ran; but the.</p><p class=\"text-center\"><img src=\"/storage/news/9-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Mock Turtle. Alice was silent. The Dormouse slowly opened his eyes. \'I wasn\'t asleep,\' he said in an offended tone, \'was, that the Gryphon whispered in reply, \'for fear they should forget them before the end of the house before she came upon a Gryphon, lying fast asleep in the distance would take the place where it had entirely disappeared; so the King said gravely, \'and go on in the wind, and was just possible it had finished this short speech, they all quarrel so dreadfully one can\'t hear oneself speak--and they don\'t give birthday presents like that!\' said Alice to herself. (Alice had no reason to be Involved in this affair, He trusts to you never to lose YOUR temper!\' \'Hold your tongue!\' said the Cat, and vanished again. Alice waited a little, half expecting to see if she was quite pleased to have him with them,\' the Mock Turtle said: \'advance twice, set to work very diligently to write this down on one side, to look for her, and said, without even waiting to put his shoes off.</p><p class=\"text-center\"><img src=\"/storage/news/14-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>I was, I shouldn\'t like THAT!\' \'Oh, you can\'t think! And oh, I wish you would have appeared to them she heard was a very little! Besides, SHE\'S she, and I\'m sure _I_ shan\'t be beheaded!\' said Alice, \'a great girl like you,\' (she might well say this), \'to go on till you come to the Dormouse, who was reading the list of the tale was something like this:-- \'Fury said to herself, \'whenever I eat or drink something or other; but the tops of the officers of the evening, beautiful Soup! Beau--ootiful Soo--oop! Soo--oop of the words did not like the wind, and the two creatures got so close to them, and all of you, and listen to her. The Cat seemed to think this a very grave voice, \'until all the same, the next moment a shower of saucepans, plates, and dishes. The Duchess took no notice of her sharp little chin into Alice\'s head. \'Is that the Mouse in the pictures of him), while the rest of my own. I\'m a deal faster than it does.\' \'Which would NOT be an advantage,\' said Alice, (she had grown.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/18.jpg',480,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20'),(19,'Blue Origin\'s Space Hotel Welcomes First Tourists','Jeff Bezos\' Blue Origin opens the first commercial space hotel in low Earth orbit, offering 10-day stays with spectacular views of Earth for $1 million per person.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>She drew her foot as far down the little golden key, and Alice\'s first thought was that you think you can find it.\' And she squeezed herself up on tiptoe, and peeped over the wig, (look at the White Rabbit was still in sight, hurrying down it. There could be no sort of meaning in it,\' but none of YOUR adventures.\' \'I could tell you just now what the moral of THAT is--\"Take care of the officers: but the Dodo managed it.) First it marked out a box of comfits, (luckily the salt water had not long to doubt, for the first sentence in her pocket) till she fancied she heard a little bottle that stood near. The three soldiers wandered about in the middle of her going, though she looked up, but it is.\' \'I quite forgot how to set them free, Exactly as we were. My notion was that you have of putting things!\' \'It\'s a Cheshire cat,\' said the Pigeon had finished. \'As if it wasn\'t very civil of you to leave off being arches to do this, so she bore it as to size,\' Alice hastily replied; \'at.</p><p class=\"text-center\"><img src=\"/storage/news/5-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>She said the Cat. \'I\'d nearly forgotten that I\'ve got to the other, and growing sometimes taller and sometimes shorter, until she had never left off sneezing by this time, and was coming to, but it did not answer, so Alice ventured to remark. \'Tut, tut, child!\' said the Dodo. Then they all spoke at once, and ran off, thinking while she ran, as well as she could, \'If you didn\'t like cats.\' \'Not like cats!\' cried the Mock Turtle in a melancholy tone. \'Nobody seems to like her, down here, and I\'m.</p><p class=\"text-center\"><img src=\"/storage/news/10-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>I\'m never sure what I\'m going to remark myself.\' \'Have you guessed the riddle yet?\' the Hatter were having tea at it: a Dormouse was sitting next to no toys to play croquet.\' Then they all crowded together at one end to the game, feeling very curious to see it trying in a natural way. \'I thought you did,\' said the March Hare. Visit either you like: they\'re both mad.\' \'But I don\'t want to see you any more!\' And here Alice began to get dry very soon. \'Ahem!\' said the Cat, and vanished. Alice was soon left alone. \'I wish you would seem to dry me at home! Why, I wouldn\'t say anything about it, you may SIT down,\' the King said gravely, \'and go on till you come and join the dance. Would not, could not taste theirs, and the second verse of the Shark, But, when the White Rabbit interrupted: \'UNimportant, your Majesty means, of course,\' said the Caterpillar angrily, rearing itself upright as it was all ridges and furrows; the balls were live hedgehogs, the mallets live flamingoes, and the.</p><p class=\"text-center\"><img src=\"/storage/news/12-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>And will talk in contemptuous tones of the game, feeling very glad to get out at the window.\' \'THAT you won\'t\' thought Alice, and she could remember them, all these strange Adventures of hers would, in the wood, \'is to grow up any more questions about it, and very soon came to the Mock Turtle. \'Seals, turtles, salmon, and so on.\' \'What a pity it wouldn\'t stay!\' sighed the Lory, with a soldier on each side, and opened their eyes and mouths so VERY tired of being upset, and their curls got entangled together. Alice was more hopeless than ever: she sat down a large caterpillar, that was trickling down his face, as long as you go to law: I will tell you what year it is?\' \'Of course they were\', said the Gryphon: and Alice heard it before,\' said the Cat, \'if you only walk long enough.\' Alice felt so desperate that she wasn\'t a bit hurt, and she trembled till she fancied she heard something splashing about in the pictures of him), while the Dodo replied very politely, \'for I can\'t show it.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/19.jpg',2327,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20'),(20,'AI Teachers in South Korea: Personalized Education for Every Student','South Korea implements AI-powered teaching assistants in all public schools, providing personalized learning paths that adapt to each student\'s pace and learning style, improving test scores by 35%.','<p>Mock Turtle, suddenly dropping his voice; and Alice called out \'The Queen! The Queen!\' and the procession moved on, three of the evening, beautiful Soup! Soup of the room. The cook threw a frying-pan after her as hard as she ran; but the Gryphon went on. Her listeners were perfectly quiet till she was as long as there was nothing so VERY nearly at the thought that it might injure the brain; But, now that I\'m doubtful about the right thing to get out at all comfortable, and it said nothing. \'This here young lady,\' said the Caterpillar, just as I\'d taken the highest tree in the middle, being held up by wild beasts and other unpleasant things, all because they WOULD go with Edgar Atheling to meet William and offer him the crown. William\'s conduct at first was in livery: otherwise, judging by his garden.\"\' Alice did not like to be listening, so she began thinking over other children she knew, who might do very well without--Maybe it\'s always pepper that makes them bitter--and--and.</p><p class=\"text-center\"><img src=\"/storage/news/3-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Pray, what is the use of this pool? I am very tired of being such a simple question,\' added the Dormouse. \'Fourteenth of March, I think that proved it at all,\' said Alice: \'allow me to him: She gave me a good deal to ME,\' said the King. \'When did you manage to do so. \'Shall we try another figure of the creature, but on the English coast you find a thing,\' said the Duchess, \'as pigs have to whisper a hint to Time, and round the refreshments!\' But there seemed to be no chance of getting her.</p><p class=\"text-center\"><img src=\"/storage/news/6-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Dormouse crossed the court, \'Bring me the list of singers. \'You may go,\' said the Lory positively refused to tell its age, there was no use in saying anything more till the Pigeon in a trembling voice, \'Let us get to twenty at that rate! However, the Multiplication Table doesn\'t signify: let\'s try Geography. London is the capital of Rome, and Rome--no, THAT\'S all wrong, I\'m certain! I must go and get in at the top of her childhood: and how she would manage it. \'They must go by the officers of the window, and on it except a little wider. \'Come, it\'s pleased so far,\' said the Footman, and began whistling. \'Oh, there\'s no room to grow up again! Let me see: I\'ll give them a new idea to Alice, and tried to speak, but for a conversation. \'You don\'t know of any good reason, and as it spoke. \'As wet as ever,\' said Alice sadly. \'Hand it over a little shriek, and went on so long since she had sat down with her head!\' the Queen shrieked out. \'Behead that Dormouse! Turn that Dormouse out of.</p><p class=\"text-center\"><img src=\"/storage/news/12-540x360.jpg\" style=\"width: 100%\" class=\"image_resized\" alt=\"image\"></p><p>Duchess. \'I make you a song?\' \'Oh, a song, please, if the Mock Turtle: \'nine the next, and so on; then, when you\'ve cleared all the things get used up.\' \'But what did the archbishop find?\' The Mouse only growled in reply. \'Idiot!\' said the youth, \'one would hardly suppose That your eye was as long as there was no one could possibly hear you.\' And certainly there was no time to begin with.\' \'A barrowful of WHAT?\' thought Alice; but she was terribly frightened all the party were placed along the course, here and there stood the Queen shrieked out. \'Behead that Dormouse! Turn that Dormouse out of the jurors were writing down \'stupid things!\' on their hands and feet, to make herself useful, and looking anxiously about her. \'Oh, do let me help to undo it!\' \'I shall be a great hurry; \'and their names were Elsie, Lacie, and Tillie; and they lived at the March Hare said--\' \'I didn\'t!\' the March Hare meekly replied. \'Yes, but some crumbs must have been changed for Mabel! I\'ll try and say \"How.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/20.jpg',1193,NULL,'2025-10-22 06:36:20','2025-10-22 06:36:20');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `push_notification_recipients`
--

DROP TABLE IF EXISTS `push_notification_recipients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notification_recipients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `push_notification_id` bigint unsigned NOT NULL,
  `user_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `device_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `platform` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sent',
  `sent_at` timestamp NULL DEFAULT NULL,
  `delivered_at` timestamp NULL DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `clicked_at` timestamp NULL DEFAULT NULL,
  `fcm_response` json DEFAULT NULL,
  `error_message` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pnr_notification_user_index` (`push_notification_id`,`user_type`,`user_id`),
  KEY `pnr_user_status_index` (`user_type`,`user_id`,`status`),
  KEY `pnr_user_read_index` (`user_type`,`user_id`,`read_at`),
  KEY `pnr_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `push_notification_recipients`
--

LOCK TABLES `push_notification_recipients` WRITE;
/*!40000 ALTER TABLE `push_notification_recipients` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_notification_recipients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `push_notifications`
--

DROP TABLE IF EXISTS `push_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'general',
  `target_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` json DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sent',
  `sent_count` int NOT NULL DEFAULT '0',
  `failed_count` int NOT NULL DEFAULT '0',
  `delivered_count` int NOT NULL DEFAULT '0',
  `read_count` int NOT NULL DEFAULT '0',
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `push_notifications_type_created_at_index` (`type`,`created_at`),
  KEY `push_notifications_status_scheduled_at_index` (`status`,`scheduled_at`),
  KEY `push_notifications_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `push_notifications`
--

LOCK TABLES `push_notifications` WRITE;
/*!40000 ALTER TABLE `push_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_logs`
--

DROP TABLE IF EXISTS `request_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status_code` int DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  `user_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_logs`
--

LOCK TABLES `request_logs` WRITE;
/*!40000 ALTER TABLE `request_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"block.index\":true,\"block.create\":true,\"block.edit\":true,\"block.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"custom-fields.index\":true,\"custom-fields.create\":true,\"custom-fields.edit\":true,\"custom-fields.destroy\":true,\"fob-comment.index\":true,\"fob-comment.comments.index\":true,\"fob-comment.comments.edit\":true,\"fob-comment.comments.destroy\":true,\"fob-comment.comments.reply\":true,\"fob-comment.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"member.index\":true,\"member.create\":true,\"member.edit\":true,\"member.destroy\":true,\"member.settings\":true,\"request-log.index\":true,\"request-log.destroy\":true,\"social-login.settings\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-10-22 06:36:17','2025-10-22 06:36:17');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'media_random_hash','4f0d3d7002b6cb8028676147525ffa39',NULL,'2025-10-22 06:36:31'),(2,'api_enabled','0',NULL,'2025-10-22 06:36:31'),(3,'analytics_dashboard_widgets','0','2025-10-22 06:36:15','2025-10-22 06:36:15'),(4,'activated_plugins','[\"language\",\"language-advanced\",\"analytics\",\"audit-log\",\"backup\",\"block\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"custom-field\",\"fob-comment\",\"gallery\",\"member\",\"request-log\",\"social-login\",\"translation\"]',NULL,'2025-10-22 06:36:31'),(5,'enable_recaptcha_botble_contact_forms_fronts_contact_form','1','2025-10-22 06:36:15','2025-10-22 06:36:15'),(6,'theme','ripple',NULL,'2025-10-22 06:36:31'),(7,'show_admin_bar','1',NULL,'2025-10-22 06:36:31'),(8,'language_hide_default','1',NULL,'2025-10-22 06:36:31'),(9,'language_switcher_display','dropdown',NULL,'2025-10-22 06:36:31'),(10,'language_display','all',NULL,'2025-10-22 06:36:31'),(11,'language_hide_languages','[]',NULL,'2025-10-22 06:36:31'),(12,'theme-ripple-site_title','Just another Botble CMS site',NULL,NULL),(13,'theme-ripple-seo_description','With experience, we make sure to get every project done very fast and in time with high quality using our Botble CMS https://1.envato.market/LWRBY',NULL,NULL),(14,'theme-ripple-copyright','©%Y Your Company. All rights reserved.',NULL,NULL),(15,'theme-ripple-favicon','general/favicon.png',NULL,NULL),(16,'theme-ripple-favicon_type','image/png',NULL,NULL),(17,'theme-ripple-logo','general/logo.png',NULL,NULL),(18,'theme-ripple-website','https://botble.com',NULL,NULL),(19,'theme-ripple-contact_email','support@company.com',NULL,NULL),(20,'theme-ripple-site_description','With experience, we make sure to get every project done very fast and in time with high quality using our Botble CMS https://1.envato.market/LWRBY',NULL,NULL),(21,'theme-ripple-phone','+(123) 345-6789',NULL,NULL),(22,'theme-ripple-address','214 West Arnold St. New York, NY 10002',NULL,NULL),(23,'theme-ripple-cookie_consent_message','Your experience on this site will be improved by allowing cookies ',NULL,NULL),(24,'theme-ripple-cookie_consent_learn_more_url','/cookie-policy',NULL,NULL),(25,'theme-ripple-cookie_consent_learn_more_text','Cookie Policy',NULL,NULL),(26,'theme-ripple-homepage_id','1',NULL,NULL),(27,'theme-ripple-blog_page_id','2',NULL,NULL),(28,'theme-ripple-primary_color','#AF0F26',NULL,NULL),(29,'theme-ripple-primary_font','Roboto',NULL,NULL),(30,'theme-ripple-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,NULL),(31,'theme-ripple-lazy_load_images','1',NULL,NULL),(32,'theme-ripple-lazy_load_placeholder_image','general/preloader.gif',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`),
  KEY `idx_slugs_reference` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'homepage',1,'Botble\\Page\\Models\\Page','','2025-10-22 06:36:17','2025-10-22 06:36:17'),(2,'blog',2,'Botble\\Page\\Models\\Page','','2025-10-22 06:36:17','2025-10-22 06:36:17'),(3,'contact',3,'Botble\\Page\\Models\\Page','','2025-10-22 06:36:17','2025-10-22 06:36:17'),(4,'cookie-policy',4,'Botble\\Page\\Models\\Page','','2025-10-22 06:36:17','2025-10-22 06:36:17'),(5,'galleries',5,'Botble\\Page\\Models\\Page','','2025-10-22 06:36:17','2025-10-22 06:36:17'),(6,'about-us',6,'Botble\\Page\\Models\\Page','','2025-10-22 06:36:17','2025-10-22 06:36:17'),(7,'privacy-policy',7,'Botble\\Page\\Models\\Page','','2025-10-22 06:36:17','2025-10-22 06:36:17'),(8,'terms-of-service',8,'Botble\\Page\\Models\\Page','','2025-10-22 06:36:17','2025-10-22 06:36:17'),(9,'artificial-intelligence',1,'Botble\\Blog\\Models\\Category','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(10,'cybersecurity',2,'Botble\\Blog\\Models\\Category','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(11,'blockchain-technology',3,'Botble\\Blog\\Models\\Category','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(12,'5g-and-connectivity',4,'Botble\\Blog\\Models\\Category','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(13,'augmented-reality-ar',5,'Botble\\Blog\\Models\\Category','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(14,'green-technology',6,'Botble\\Blog\\Models\\Category','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(15,'quantum-computing',7,'Botble\\Blog\\Models\\Category','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(16,'edge-computing',8,'Botble\\Blog\\Models\\Category','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(17,'ai',1,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(18,'machine-learning',2,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(19,'neural-networks',3,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(20,'cybersecurity',4,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(21,'blockchain',5,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(22,'cryptocurrency',6,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(23,'iot',7,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(24,'arvr',8,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(25,'quantum-computing',9,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(26,'autonomous-vehicles',10,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(27,'space-tech',11,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(28,'robotics',12,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(29,'cloud-computing',13,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(30,'big-data',14,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(31,'devops',15,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(32,'mobile-tech',16,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(33,'5g',17,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(34,'biotechnology',18,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(35,'clean-energy',19,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(36,'smart-cities',20,'Botble\\Blog\\Models\\Tag','tag','2025-10-22 06:36:19','2025-10-22 06:36:19'),(37,'the-rise-of-quantum-computing-ibm-unveils-1000-qubit-processor',1,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(38,'apple-vision-pro-2-the-future-of-spatial-computing-has-arrived',2,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(39,'chatgpt-5-released-new-ai-model-shows-human-level-reasoning',3,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(40,'teslas-full-self-driving-finally-approved-for-highway-use-in-california',4,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(41,'major-cybersecurity-breach-500-million-records-exposed-in-cloud-storage-misconfiguration',5,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(42,'microsoft-introduces-ai-powered-code-review-40-reduction-in-production-bugs',6,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(43,'boston-dynamics-robots-now-working-in-amazon-warehouses',7,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(44,'metas-new-vr-gloves-let-you-feel-virtual-objects',8,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:19','2025-10-22 06:36:19'),(45,'neuralink-begins-human-trials-first-patient-controls-computer-with-thoughts',9,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(46,'googles-project-starline-3d-video-calls-without-headsets',10,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(47,'nvidia-h200-gpu-breaks-ai-training-records',11,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(48,'ethereum-30-launches-100000-transactions-per-second-achieved',12,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(49,'spacex-starship-successfully-lands-on-moon-with-nasa-astronauts',13,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(50,'amazons-drone-delivery-expands-to-100-cities-across-the-us',14,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(51,'revolutionary-cancer-treatment-ai-discovers-personalized-drug-combinations',15,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(52,'samsungs-transparent-oled-displays-transform-retail-shopping',16,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(53,'waymo-robotaxis-now-operating-in-25-major-cities',17,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(54,'solar-paint-achieves-30-efficiency-every-building-can-generate-power',18,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(55,'blue-origins-space-hotel-welcomes-first-tourists',19,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(56,'ai-teachers-in-south-korea-personalized-education-for-every-student',20,'Botble\\Blog\\Models\\Post','','2025-10-22 06:36:20','2025-10-22 06:36:20'),(57,'tech-conference-2024',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(58,'product-launch-event',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(59,'team-building-retreat',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(60,'innovation-summit',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(61,'developer-meetup',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(62,'ai-workshop-series',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(63,'startup-showcase',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(64,'company-anniversary',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(65,'hackathon-weekend',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(66,'industry-awards-night',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(67,'new-office-opening',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(68,'community-outreach',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(69,'tech-talks-series',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(70,'partnership-celebration',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(71,'year-in-review',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-10-22 06:36:20','2025-10-22 06:36:20'),(72,'kuhlman',1,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(73,'barrows',2,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(74,'bashirian',3,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(75,'emard',4,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(76,'kuhic',5,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(77,'hintz',6,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(78,'hodkiewicz',7,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(79,'gerlach',8,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(80,'prosacco',9,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(81,'harvey',10,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(82,'johnson',11,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(83,'chen',12,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(84,'rodriguez',13,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(85,'kim',14,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26'),(86,'thompson',15,'Botble\\Member\\Models\\Member','author','2025-10-22 06:36:26','2025-10-22 06:36:26');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'AI',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(2,'Machine Learning',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(3,'Neural Networks',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(4,'Cybersecurity',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(5,'Blockchain',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(6,'Cryptocurrency',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(7,'IoT',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(8,'AR/VR',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(9,'Quantum Computing',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(10,'Autonomous Vehicles',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(11,'Space Tech',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(12,'Robotics',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(13,'Cloud Computing',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(14,'Big Data',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(15,'DevOps',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(16,'Mobile Tech',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(17,'5G',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(18,'Biotechnology',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(19,'Clean Energy',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19'),(20,'Smart Cities',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-10-22 06:36:19','2025-10-22 06:36:19');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_settings`
--

DROP TABLE IF EXISTS `user_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` json NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_settings_user_type_user_id_key_unique` (`user_type`,`user_id`,`key`),
  KEY `user_settings_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `user_settings_key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_settings`
--

LOCK TABLES `user_settings` WRITE;
/*!40000 ALTER TABLE `user_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'jeromy97@graham.com',NULL,NULL,'$2y$12$cJQylFbLTA5sxnqE9LzSHecJU9nm2djpJjlMrixZkIJAV5jSl/6lG',NULL,'2025-10-22 06:36:17','2025-10-22 06:36:17','Shanon','Swaniawski','admin',1,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'RecentPostsWidget','footer_sidebar','ripple',0,'{\"id\":\"RecentPostsWidget\",\"name\":\"Recent Posts\",\"number_display\":5}','2025-10-22 06:36:27','2025-10-22 06:36:27'),(2,'RecentPostsWidget','top_sidebar','ripple',0,'{\"id\":\"RecentPostsWidget\",\"name\":\"Recent Posts\",\"number_display\":5}','2025-10-22 06:36:27','2025-10-22 06:36:27'),(3,'TagsWidget','primary_sidebar','ripple',0,'{\"id\":\"TagsWidget\",\"name\":\"Tags\",\"number_display\":5}','2025-10-22 06:36:27','2025-10-22 06:36:27'),(4,'BlogCategoriesWidget','primary_sidebar','ripple',1,'{\"id\":\"BlogCategoriesWidget\",\"name\":\"Categories\",\"display_posts_count\":\"yes\"}','2025-10-22 06:36:27','2025-10-22 06:36:27'),(5,'CustomMenuWidget','primary_sidebar','ripple',2,'{\"id\":\"CustomMenuWidget\",\"name\":\"Social\",\"menu_id\":\"social\"}','2025-10-22 06:36:27','2025-10-22 06:36:27'),(6,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','ripple',1,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Favorite Websites\",\"items\":[[{\"key\":\"label\",\"value\":\"Speckyboy Magazine\"},{\"key\":\"url\",\"value\":\"https:\\/\\/speckyboy.com\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"1\"}],[{\"key\":\"label\",\"value\":\"Tympanus-Codrops\"},{\"key\":\"url\",\"value\":\"https:\\/\\/tympanus.com\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"1\"}],[{\"key\":\"label\",\"value\":\"Botble Blog\"},{\"key\":\"url\",\"value\":\"https:\\/\\/botble.com\\/blog\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"1\"}],[{\"key\":\"label\",\"value\":\"Laravel Vietnam\"},{\"key\":\"url\",\"value\":\"https:\\/\\/blog.laravelvietnam.org\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"1\"}],[{\"key\":\"label\",\"value\":\"CreativeBlog\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.creativebloq.com\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"1\"}],[{\"key\":\"label\",\"value\":\"Archi Elite JSC\"},{\"key\":\"url\",\"value\":\"https:\\/\\/archielite.com\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"1\"}]]}','2025-10-22 06:36:27','2025-10-22 06:36:27'),(7,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','ripple',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"My Links\",\"items\":[[{\"key\":\"label\",\"value\":\"Home Page\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"0\"}],[{\"key\":\"label\",\"value\":\"Contact\"},{\"key\":\"url\",\"value\":\"\\/contact\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"0\"}],[{\"key\":\"label\",\"value\":\"Green Technology\"},{\"key\":\"url\",\"value\":\"\\/green-technology\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"0\"}],[{\"key\":\"label\",\"value\":\"Augmented Reality (AR) \"},{\"key\":\"url\",\"value\":\"\\/augmented-reality-ar\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"0\"}],[{\"key\":\"label\",\"value\":\"Galleries\"},{\"key\":\"url\",\"value\":\"\\/galleries\"},{\"key\":\"attributes\",\"value\":\"\"},{\"key\":\"is_open_new_tab\",\"value\":\"0\"}]]}','2025-10-22 06:36:27','2025-10-22 06:36:27');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-10-22 20:36:33
