<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    public function up(): void
    {
        if (! Schema::hasTable('contacts')) {
            Schema::create('contacts', function (Blueprint $table) {
                $table->id();
                $table->string('name', 255);
                $table->string('status', 60)->default('published');
                $table->timestamps();
            });
        }

        if (! Schema::hasTable('contacts_translations')) {
            Schema::create('contacts_translations', function (Blueprint $table) {
                $table->string('lang_code');
                $table->foreignId('contacts_id');
                $table->string('name', 255)->nullable();

                $table->primary(['lang_code', 'contacts_id'], 'contacts_translations_primary');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('contacts');
        Schema::dropIfExists('contacts_translations');
    }
};
