<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('clients', function (Blueprint $table) {
            $table->double('balance')->default(0)->after('status');
            $table->unsignedBigInteger('rtn')->nullable()->after('balance');
            $table->string('city', 50)->nullable()->after('rtn');
            $table->string('state', 50)->nullable()->after('city');
            $table->unsignedBigInteger('zip')->nullable()->after('state');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('clients', function (Blueprint $table) {
            $table->dropColumn(['balance', 'rtn', 'city', 'state', 'zip']);
        });
    }
};
