<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('clients', function (Blueprint $table) {
            // Requiere doctrine/dbal para usar change()
            $table->text('address')->after('name');
            $table->string('website', 300)->after('address')->change();
        });
    }

    public function down(): void
    {
        Schema::table('clients', function (Blueprint $table) {
            $table->dropColumn('address');

            $table->string('website', 300)->after('name')->change();
        });
    }
};
