<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('clients', function (Blueprint $table) {
            // Mover address debajo de zip
            $table->text('address')->after('zip')->change();

            // Mover website debajo de address
            $table->string('website', 300)->after('address')->change();
        });
    }

    public function down(): void
    {
        Schema::table('clients', function (Blueprint $table) {
            // Devolver address y website a su orden anterior si se desea
            $table->text('address')->after('name')->change();
            $table->string('website', 300)->after('address')->change();
        });
    }
};
