<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateContactsTableAddClientIdAndReorderStatus extends Migration
{
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            // Agrega client_id después de name
            if (!Schema::hasColumn('contacts', 'client_id')) {
                $table->unsignedBigInteger('client_id')->nullable()->after('name');
            }
        });

        // Reordenar 'status' moviéndolo después de 'id'
        DB::statement('ALTER TABLE contacts MODIFY COLUMN status VARCHAR(191) NULL DEFAULT NULL AFTER id');
    }

    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            // Elimina client_id
            if (Schema::hasColumn('contacts', 'client_id')) {
                $table->dropColumn('client_id');
            }

            // No es posible revertir con precisión el cambio de orden del campo 'status' sin saber su posición anterior exacta.
            // Aquí lo regresamos después de 'name' como ejemplo:
            DB::statement('ALTER TABLE contacts MODIFY COLUMN status VARCHAR(191) NULL DEFAULT NULL AFTER name');
        });
    }
}
