<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPersonalFieldsToContactsTable extends Migration
{
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->string('firstname', 100)->after('client_id');
            $table->string('middlename', 100)->nullable()->after('firstname');
            $table->string('lastname', 100)->after('middlename');
            $table->string('secondlastname', 100)->nullable()->after('lastname');
            $table->string('nid', 20)->after('secondlastname');
            $table->string('email', 191)->after('nid');
            $table->string('username', 50)->after('email');
            $table->string('password', 255)->after('username');
            $table->string('phone1', 25)->nullable()->after('password');
            $table->string('phone2', 25)->nullable()->after('phone1');
            $table->string('photo', 255)->nullable()->after('phone2');
            $table->boolean('notify_sms')->default(false)->after('photo');
            $table->boolean('notify_whastapp')->default(false)->after('notify_sms');
        });
    }

    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn([
                'firstname',
                'middlename',
                'lastname',
                'secondlastname',
                'nid',
                'email',
                'username',
                'password',
                'phone1',
                'phone2',
                'photo',
                'notify_sms',
                'notify_whastapp',
            ]);
        });
    }
}
