<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateContactsAddIsPrimaryAndRemoveName extends Migration
{
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            // Agrega campo is_primary
            $table->boolean('is_primary')->default(false)->after('client_id');

            // Elimina campo name si existe
            if (Schema::hasColumn('contacts', 'name')) {
                $table->dropColumn('name');
            }
        });
    }

    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            // Reagrega campo name
            $table->string('name', 191)->nullable();

            // Elimina is_primary
            $table->dropColumn('is_primary');
        });
    }
}
