<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterContactsAddForeignKeyClientId extends Migration
{
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            // Asegurarse de que el campo sea NOT NULL
            $table->unsignedBigInteger('client_id')->nullable(false)->change();

            // Agregar la clave foránea si no existe
            $table->foreign('client_id')
                ->references('id')->on('clients')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            // Eliminar la clave foránea
            $table->dropForeign(['client_id']);

            // Volver a hacer el campo nullable (si se desea revertir completamente)
            $table->unsignedBigInteger('client_id')->nullable()->change();
        });
    }
}
