<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RenameNotifyWhastappToNotifyWhatsappInClientsTable extends Migration
{
    /**
     * Ejecutar la migración.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('contacts', function (Blueprint $table) {
            // Renombramos la columna 'notify_whastapp' a 'notify_whatsapp'
            $table->renameColumn('notify_whastapp', 'notify_whatsapp');
        });
    }

    /**
     * Revertir la migración.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('contacts', function (Blueprint $table) {
            // Revertir el nombre de la columna en caso de una reversión
            $table->renameColumn('notify_whatsapp', 'notify_whastapp');
        });
    }
}
