<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RenameAndUpdateStateCityColumns extends Migration
{
    public function up(): void
    {
        Schema::table('clients', function (Blueprint $table) {
            // Renombrar columnas
            $table->renameColumn('state', 'state_id');
            $table->renameColumn('city', 'city_id');
        });

        Schema::table('clients', function (Blueprint $table) {
            // Cambiar tipo a BIGINT UNSIGNED NOT NULL
            $table->unsignedBigInteger('state_id')->change();
            $table->unsignedBigInteger('city_id')->change();
        });
    }

    public function down(): void
    {
        Schema::table('clients', function (Blueprint $table) {
            $table->renameColumn('state_id', 'state');
            $table->renameColumn('city_id', 'city');
        });

        Schema::table('clients', function (Blueprint $table) {
            // Revertir a tipo anterior (asumo string, ajuste si era otro tipo)
            $table->string('state')->change();
            $table->string('city')->change();
        });
    }
}
