<?php

use Botble\Base\Facades\AdminHelper;
use ISPManager\Clients\Http\Controllers\ClientsController;
use ISPManager\Clients\Http\Controllers\ContactsController;
use Illuminate\Support\Facades\Route;

AdminHelper::registerRoutes(function () {
    // /admin/clients
    Route::resource('clients', ClientsController::class)
        ->parameters(['clients' => 'client']); // {client}

    // /admin/clients/{client}/contacts
    Route::resource('clients.contacts', ContactsController::class)
        ->parameters(['clients' => 'client', 'contacts' => 'contact']); // {client}/{contact}
        // ->shallow(); // opcional
});
