<?php

namespace ISPManager\Clients\Enums;

use Botble\Base\Facades\Html;
use Botble\Base\Supports\Enum;
use Illuminate\Support\HtmlString;

/**
 * @method static ClientStatusEnum ENABLED()
 * @method static ClientStatusEnum DISABLED()
 */
class ClientStatusEnum extends Enum
{
    public const ENABLED = 'enabled';

    public const DISABLED = 'disabled';

    public static $langPath = 'plugins/clients::clients.statuses';

    public function toHtml(): HtmlString|string
    {
        return match ($this->value) {
            self::DISABLED => Html::tag('span', self::DISABLED()->label(), ['class' => 'badge bg-danger text-danger-fg']),
            self::ENABLED => Html::tag('span', self::ENABLED()->label(), ['class' => 'badge bg-success text-success-fg']),
            default => parent::toHtml(),
        };
    }
}
