<?php

namespace ISPManager\Clients\Forms;

use Botble\Base\Forms\FieldOptions\NameFieldOption;
use Botble\Base\Forms\FieldOptions\StatusFieldOption;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Base\Forms\Fields\TextareaField;
use Botble\Base\Forms\FormAbstract;
use ISPManager\Clients\Http\Requests\ClientsRequest;
use ISPManager\Clients\Models\Client;
use ISPManager\Clients\Enums\ClientStatusEnum;
use ISPManager\Clients\Models\Country;
use ISPManager\Clients\Models\State;
use ISPManager\Clients\Models\City;

class ClientsForm extends FormAbstract
{
    public function setup(): void
    {
        $this
            ->model(Client::class)
            ->setValidatorClass(ClientsRequest::class)
            ->add('name', TextField::class, NameFieldOption::make()->required())
            ->add('rtn', TextField::class, [
                'label' => trans('plugins/clients::clients.rtn'),
                'attr' => ['placeholder' => trans('plugins/clients::clients.rtn')],
                'rules' => 'nullable|numeric|min:0',
            ])
            ->add('country_id', SelectField::class, [
                'label' => trans('plugins/clients::clients.country'),
                'choices' => [null => trans('plugins/clients::clients.selectcountry')] + Country::pluck('name', 'id')->all(),
                'attr' => ['class' => 'form-control select-search-full'],
                'rules' => 'required|integer|exists:countries,id|not_in:',
            ])
            ->add('state_id', SelectField::class, [
                'label' => trans('plugins/clients::clients.state'),
                'choices' => [null => trans('plugins/clients::clients.selectstate')] + State::pluck('name', 'id')->all(),
                'attr' => ['class' => 'form-control select-search-full'],
                'rules' => 'required|integer|exists:state,id|not_in:',
            ])
            ->add('city_id', SelectField::class, [
                'label' => trans('plugins/clients::clients.city'),
                'choices' => [null => trans('plugins/clients::clients.selectcity')] + City::pluck('name', 'id')->all(),
                'attr' => ['class' => 'form-control select-search-full'],
                'rules' => 'required|integer|exists:city,id|not_in:',
            ])
            ->add('zip', TextField::class, [
                'label' => trans('plugins/clients::clients.zip'),
                'attr' => ['placeholder' => trans('plugins/clients::clients.zip')],
                'rules' => 'nullable|numeric|min:0',
            ])

            ->add('address', TextareaField::class, [
                'label' => trans('plugins/clients::clients.address'),
                'attr' => [
                    'rows' => 3,
                    'placeholder' => trans('plugins/clients::clients.address'),
                ],
                'rules' => 'nullable|string|max:1000',
            ])
            ->add('website', TextField::class, NameFieldOption::make()->placeholder('https://web.com')->maxLength(300)
            ->label(trans('plugins/clients::clients.website')))
            ->add('status', SelectField::class, StatusFieldOption::make()
                ->choices(ClientStatusEnum::labels()))
            
            ->setBreakFieldPoint('status');
    }
}
