<?php

namespace ISPManager\Clients\Http\Controllers;

use Botble\Base\Http\Actions\DeleteResourceAction;
use ISPManager\Clients\Http\Requests\ContactsRequest;
use ISPManager\Clients\Models\Contact;
use Botble\Base\Supports\Breadcrumb;
use Botble\Base\Http\Controllers\BaseController;
use ISPManager\Clients\Tables\ContactsTable;
use ISPManager\Clients\Forms\ContactsForm;
use Illuminate\Support\Facades\Hash;

class ContactsController extends BaseController
{

    public function __construct()
    {
    }

    protected function breadcrumb(): Breadcrumb
    {
        return parent::breadcrumb()
            ->add(trans('plugins/clients::clients.name'), route('clients.index'))
            ->add(trans('plugins/clients::contacts.name'), route('clients.contacts.index'));
    }

    public function index(ContactsTable $table)
    {
        $this->pageTitle(trans('plugins/clients::contacts.name'));

        return $table->renderTable();
    }

    public function create()
    {
        $this->pageTitle(trans('plugins/clients::contacts.create'));

        return ContactsForm::create()
            ->remove('is_change_password')
            ->renderForm();
    }

    public function store(ContactsRequest $request)
    {
        $form = ContactsForm::create();
        $form
            ->saving(function (ContactsForm $form) use ($request): void {
                $contacts = $form->getModel();
                //dd($request->all());
                $contacts->fill($request->except('password'));
                $contacts->password = Hash::make($request->input('password'));

                //if (($avatarInput = $request->input('avatar_image')) && $image = MediaFile::query()->where('url', $avatarInput)->first()) {
                //    $contacts->avatar_id = $image->getKey();
                //}

                $contacts->save();
            });

        return $this
            ->httpResponse()
            ->setPreviousUrl(route('clients.contacts.index'))
            ->setNextUrl(route('clients.contacts.edit', $form->getModel()->getKey()))
            ->setMessage(trans('core/base::notices.create_success_message'));
    }

    public function edit(Contact $contacts)
    {
        $this->pageTitle(trans('core/base::forms.edit_item', ['name' => $contacts->firstname . ' ' . $contacts->lastname]));
        $contacts->password = null; 
        return ContactsForm::createFromModel($contacts)->renderForm();
    }

    public function update(Contact $contacts, ContactsRequest $request)
    {

        ContactsForm::createFromModel($contacts)
            ->saving(function (ContactsForm $form) use ($request): void {
                $contacts = $form->getModel();
                $contacts->fill($request->except('password'));

                if ($request->input('is_change_password') == 1) {
                    $contacts->password = Hash::make($request->input('password'));
                }

                //if (($avatarInput = $request->input('avatar_image')) && $image = MediaFile::query()->where('url', $avatarInput)->first()) {
                //    $contacts->avatar_id = $image->getKey();
                //}

                $contacts->save();
            });

        return $this
            ->httpResponse()
            ->setPreviousUrl(route('clients.contacts.index'))
            ->setMessage(trans('core/base::notices.update_success_message'));
    }

    public function destroy(Contact $contacts)
    {
        return DeleteResourceAction::make($contacts);
    }
}
