<?php

namespace ISPManager\Clients\Http\Requests;

use ISPManager\Clients\Enums\ClientStatusEnum;
use Botble\Support\Http\Requests\Request;
use Illuminate\Validation\Rule;

class ClientsRequest extends Request
{
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:250'],
            'status' => Rule::in(ClientStatusEnum::values()),
            'country_id' => ['required', 'integer', 'exists:countries,id', 'not_in:'],
            'website' => ['nullable', 'string', 'max:300'],
            'rtn' => ['nullable', 'numeric', 'min:0'],
            'city_id' => ['required', 'integer', 'exists:cities,id', 'not_in:'],
            'state_id' => ['required', 'integer', 'exists:states,id', 'not_in:'],
            'zip' => ['nullable', 'numeric', 'min:0'],
            'address' => ['nullable', 'string', 'max:1000'],
        ];
    }
}
