<?php

namespace ISPManager\Clients\Http\Requests;

use ISPManager\Clients\Enums\ClientStatusEnum;
use Botble\Support\Http\Requests\Request;
use Illuminate\Validation\Rule;

class ContactsRequest extends Request
{
    public function rules(): array
    {
        $id = $this->route('contacts')?->id;
        $rules = [
            'client_id' => ['required', 'exists:clients,id'],
            'status' => Rule::in(ClientStatusEnum::values()),
            'is_primary' => ['nullable', 'boolean'],
            'firstname' => ['required', 'string', 'max:100'],
            'middlename' => ['nullable', 'string', 'max:100'],
            'lastname' => ['required', 'string', 'max:100'],
            'secondlastname' => ['nullable', 'string', 'max:100'],
            'nid' => ['nullable', 'string', 'max:20'],
            'email' => ['required', 'string', 'email', 'max:200', 'unique:contacts,email' . ($id ? ",{$id},id" : '')],
            'username' => ['required', 'string', 'max:50', 'unique:contacts,username' . ($id ? ",{$id},id" : '')],
            'phone1' => ['nullable', 'string', 'max:25'],
            'phone2' => ['nullable', 'string', 'max:25'],
            'notify_sms' => ['nullable', 'boolean'],
            'notify_whatsapp' => ['nullable', 'boolean'],
            'password' => [
                'required',
                'string',
                'min:6',
                'confirmed',
            ],
            'password_confirmation' => [
                'required',
                'string',
                'min:6',
            ],
        ];

        if ($id && $this->input('is_change_password') != 1) {
            unset($rules['password']);
            unset($rules['password_confirmation']);
        }
        
        return $rules;
    }
}
