<?php

namespace ISPManager\Clients\Models;

use Botble\Base\Casts\SafeContent;
use Botble\Base\Enums\BaseStatusEnum;
use Botble\Base\Models\BaseModel;
use ISPManager\Clients\Enums\ClientStatusEnum;
use ISPManager\Clients\Models\Country;
use ISPManager\Clients\Models\Contact;

class Client extends BaseModel
{
    protected $table = 'clients';
    protected $appends = [
        'primary_contact_name',
    ];
    
    protected $fillable = [
        'name',
        'status',
        'website',
        'country_id',
        'rtn',
        'city_id',
        'state_id',
        'zip',
        'address',
    ];

    protected $casts = [
        'status' => ClientStatusEnum::class,
        'name' => SafeContent::class,
        'website' => SafeContent::class,
        'country_id' => 'integer',
        'rtn' => 'integer',
        'city_id' => 'integer',
        'state_id' => 'integer',
        'zip' => 'integer',
        'address' => SafeContent::class,
    ];

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function contacts()
    {
        return $this->hasMany(Contact::class, 'client_id');
    }
    
    public function getPrimaryContactNameAttribute(): string
    {
        $contact = $this->contacts()->where('is_primary', true)->first();

        return $contact
            ? $contact->firstname . ' ' . $contact->lastname
            : '—';
    }
}
