<?php

namespace ISPManager\Clients\Providers;

use Botble\Base\Supports\ServiceProvider;
use Botble\Base\Traits\LoadAndPublishDataTrait;
use Botble\Base\Facades\DashboardMenu;
use ISPManager\Clients\Models\Client;

class ClientsServiceProvider extends ServiceProvider
{
    use LoadAndPublishDataTrait;

    public function boot(): void
    {
        $this
            ->setNamespace('plugins/clients')
            ->loadHelpers()
            ->loadAndPublishConfigurations(['permissions'])
            ->loadAndPublishTranslations()
            ->loadRoutes()
            ->loadAndPublishViews()
            ->loadMigrations();

        if (defined('LANGUAGE_ADVANCED_MODULE_SCREEN_NAME')) {
            \Botble\LanguageAdvanced\Supports\LanguageAdvancedManager::registerModule(Client::class, [
                'name',
            ]);
        }

        // Modify the Dashboard menu registration
        DashboardMenu::default()->beforeRetrieving(function () {
            // Register the Clients menu item (main menu item)
            DashboardMenu::registerItem([
                'id' => 'cms-plugins-clients',
                'priority' => 5,
                'parent_id' => null, // No parent, it’s a main item
                'name' => 'plugins/clients::clients.name',
                'icon' => 'ti ti-user',
                'url' => route('clients.index'),
                'permissions' => ['clients.index'],
            ]);

            // Optionally, add a "Clients" option in the menu
            //DashboardMenu::registerItem([
                //'id' => 'cms-plugins-contacts',
                //'priority' => 1, // Place this item below Contacts
                //'parent_id' => 'cms-plugins-clients', // Parent is Clients menu
                //'name' => 'plugins/clients::clients.name', // The same name as Clients
                //'icon' => 'ti ti-user',
                //'url' => route('clients.index'), // The URL you want Clients to link to
                //'permissions' => ['clients.index'],
            //]);

            // Register the Contacts option as a child of Clients
            //DashboardMenu::registerItem([
                //'id' => 'cms-plugins-clients-contacts', // Unique ID for this child item
                //'priority' => 0,
                //'parent_id' => 'cms-plugins-clients', // Parent is Clients menu
                //'name' => 'plugins/clients::contacts.name',
                //'icon' => 'ti ti-users',
                //'url' => route('clients.contacts.index'),
                //'permissions' => ['contacts.index'],
            //]);
            
        });
    }
}
