<?php

namespace ISPManager\Clients\Tables\BulkChanges;

use Botble\Table\BulkChanges\StatusBulkChange;
use ISPManager\Clients\Enums\ClientStatusEnum;
use Illuminate\Validation\Rule;

class ClientStatusBulkChange extends StatusBulkChange
{
    public static function make(array $data = []): static
    {
        return parent::make()
            ->name('status')
            ->title(trans('core/base::tables.status'))
            ->type('customSelect')
            ->choices(ClientStatusEnum::labels());
    }

    public function toArray(): array
    {
        return [
            ...parent::toArray(),
            'validate' => ['required', Rule::in(array_keys($this->choices))],
        ];
    }
}
