<?php

namespace ISPManager\Clients\Tables\Columns;

use Botble\Table\Columns\FormattedColumn;
use Botble\Table\Contracts\FormattedColumn as FormattedColumnContract;
use Botble\Table\Columns\Concerns\IconPosition;

class CountColumn extends FormattedColumn implements FormattedColumnContract
{
    protected string $icon = '';

    protected IconPosition $iconPosition = IconPosition::Start;

    public static function make(array|string $data = [], string $name = ''): static
    {
        return parent::make($data, $name)
            ->escape(false)
            ->alignCenter();
    }

    public function icon(?string $icon): static
    {
        $this->icon = $icon ?? '';
        return $this;
    }

    public function iconPosition(?IconPosition $position): static
    {
        if ($position !== null) {
            $this->iconPosition = $position;
        }

        return $this;
    }

    public function formattedValue($value): ?string
    {
        $count = $value ?: 0;
        $color = $count > 0 ? 'success' : 'secondary'; // success = verde, secondary = gris

        $iconHtml = $this->icon ? '<i class="' . e($this->icon) . '"></i>' : '';

        $content = match ($this->iconPosition) {
            IconPosition::Start => $iconHtml . ' ' . $count,
            IconPosition::End => $count . ' ' . $iconHtml,
        };

        return '<span class="badge bg-' . $color . ' text-white">' . $content . '</span>';
    }
}
