</div>
<footer class="page-footer bg-dark pt-50">
    <div class="container">
        <div class="row">
            <?php if(theme_option('address') || theme_option('website') || theme_option('contact_email') || theme_option('site_description')): ?>
            <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                <aside class="widget widget--transparent widget__footer widget__about">
                    <div class="widget__header">
                        <h3 class="widget__title"><?php echo e(__('About us')); ?></h3>
                    </div>
                    <div class="widget__content">
                        <p><?php echo e(theme_option('site_description')); ?></p>
                        <div class="person-detail">
                            <?php if($address = theme_option('address')): ?>
                                <p><?php echo BaseHelper::renderIcon('ti ti-home'); ?> <?php echo e($address); ?></p>
                            <?php endif; ?>
                            <?php if($website = theme_option('website')): ?>
                                <p><?php echo BaseHelper::renderIcon('ti ti-world'); ?> <?php echo e(Html::link($website)); ?></p>
                            <?php endif; ?>
                            <?php if($email = theme_option('contact_email')): ?>
                                <p><?php echo BaseHelper::renderIcon('ti ti-mail'); ?> <?php echo e(Html::mailto($email)); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </aside>
            </div>
            <?php endif; ?>
            <?php echo dynamic_sidebar('footer_sidebar'); ?>

        </div>
    </div>
    <div class="page-footer__bottom">
        <div class="container">
            <div class="row">
                <?php if($copyright = Theme::getSiteCopyright()): ?>
                    <div class="col-md-8 col-sm-6 text-start">
                        <div class="page-copyright">
                            <p><?php echo $copyright; ?></p>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if($socialLinks = Theme::getSocialLinks()): ?>
                    <div class="col-md-4 col-sm-6 text-end">
                        <div class="page-footer__social">
                            <ul class="social social--simple">
                                <?php $__currentLoopData = $socialLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(! $icon = $socialLink->getIconHtml()) continue; ?>

                                    <li>
                                        <a <?php echo e($socialLink->getAttributes()); ?>>
                                            <?php echo e($icon); ?>

                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</footer>
<div id="back2top">
    <?php echo BaseHelper::renderIcon('ti ti-arrow-narrow-up'); ?>

</div>

<?php echo Theme::footer(); ?>


</body>
</html>
<?php /**PATH D:\OneDrive\GOZFLY\ISPManager\ISPManager2\platform\themes/ripple/partials/footer.blade.php ENDPATH**/ ?>