<!DOCTYPE html>
<html <?php echo Theme::htmlAttributes(); ?>>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=5, user-scalable=1" name="viewport"/>
        <meta name="format-detection" content="telephone=no">
        <meta name="mobile-web-app-capable" content="yes">

        <?php (Theme::set('headerMeta', Theme::partial('header-meta'))); ?>

        <?php echo Theme::header(); ?>

    </head>
    <body <?php echo Theme::bodyAttributes(); ?>>
    <?php echo apply_filters(THEME_FRONT_BODY, null); ?>

    <header class="header" id="header">
        <div class="header-wrap d-none d-sm-block">
            <nav class="nav-top">
                <div class="container">
                    <div class="row">
                        <?php if($socialLinks = Theme::getSocialLinks()): ?>
                            <div class="col-sm-4 d-flex align-items-center" style="min-height: 40px;">
                                <ul class="social social--simple">
                                    <?php $__currentLoopData = $socialLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(! $icon = $socialLink->getIconHtml()) continue; ?>

                                        <li>
                                            <a <?php echo e($socialLink->getAttributes()); ?>>
                                                <?php echo e($icon); ?>

                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <div class="col-sm-8 d-flex align-items-center justify-content-end nav-top-right">
                            <?php if(is_plugin_active('member') && setting('member_enabled_login', true)): ?>
                                <ul class="d-flex">
                                    <?php if(auth('member')->check()): ?>
                                        <li><a href="<?php echo e(route('public.member.dashboard')); ?>" rel="nofollow"><img src="<?php echo e(auth('member')->user()->avatar_thumb_url); ?>" class="img-circle" width="20" alt="<?php echo e(auth('member')->user()->name); ?>" loading="lazy"> &nbsp;<span><?php echo e(auth('member')->user()->name); ?></span></a></li>
                                        <li><a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" rel="nofollow"><?php echo BaseHelper::renderIcon('ti ti-login-2'); ?> <?php echo e(__('Logout')); ?></a></li>
                                    <?php else: ?>
                                        <li><a href="<?php echo e(route('public.member.login')); ?>" rel="nofollow"><?php echo BaseHelper::renderIcon('ti ti-login-2'); ?> <?php echo e(__('Login')); ?></a></li>
                                    <?php endif; ?>
                                </ul>
                                <?php if(auth('member')->check()): ?>
                                    <form id="logout-form" action="<?php echo e(route('public.member.logout')); ?>" method="POST" style="display: none;">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                <?php endif; ?>
                            <?php endif; ?>

                            <div class="language-wrapper d-sm-inline-block">
                                <?php echo apply_filters('language_switcher'); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
    </header>
    <header data-sticky="false" data-sticky-checkpoint="200" data-responsive="991" class="page-header page-header--light">
        <div class="container">
            <div class="page-header__left">
                <a href="<?php echo e(BaseHelper::getHomepageUrl()); ?>" class="page-logo">
                    <?php echo e(Theme::getLogoImage(maxHeight: 50)); ?>

                </a>
            </div>
            <div class="page-header__right">
                <div class="navigation-toggle navigation-toggle--dark" style="display: none"><span></span></div>
                <div class="float-start">
                    <div class="search-btn c-search-toggler">
                        <?php echo BaseHelper::renderIcon('ti ti-search', attributes: ['class' => 'close-search']); ?>

                    </div>
                    <nav class="navigation navigation--light navigation--fade navigation--fadeLeft">
                        <?php echo Menu::renderMenuLocation('main-menu', [
                                'options' => ['class' => 'menu sub-menu--slideLeft'],
                                'view'    => 'main-menu',
                            ]); ?>


                        <?php if(is_plugin_active('member')): ?>
                            <ul class="menu sub-menu--slideLeft d-block d-sm-none">
                                <?php if(auth('member')->check()): ?>
                                    <li class="menu-item">
                                        <a href="<?php echo e(route('public.member.dashboard')); ?>" rel="nofollow">
                                            <img src="<?php echo e(auth('member')->user()->avatar_thumb_url); ?>" class="img-circle" width="20" alt="<?php echo e(auth('member')->user()->name); ?>" loading="lazy">
                                             &nbsp;<span><?php echo e(auth('member')->user()->name); ?></span>
                                        </a>
                                    </li>
                                    <li class="menu-item"><a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" rel="nofollow"><?php echo BaseHelper::renderIcon('ti ti-logout-2'); ?> <?php echo e(__('Logout')); ?></a></li>
                                <?php else: ?>
                                    <li class="menu-item"><a href="<?php echo e(route('public.member.login')); ?>" rel="nofollow"><?php echo BaseHelper::renderIcon('ti ti-login-2'); ?> <?php echo e(__('Login')); ?></a></li>
                                <?php endif; ?>
                            </ul>
                        <?php endif; ?>

                        <li class="language-wrapper d-block d-sm-none">
                            <?php echo apply_filters('language_switcher'); ?>

                        </li>
                    </nav>

                </div>
                <div class="clearfix"></div>
            </div>
            <div class="clearfix"></div>
        </div>
        <?php if(is_plugin_active('blog')): ?>
            <div class="super-search hide" data-search-url="<?php echo e(route('public.ajax.search')); ?>">
                <form class="quick-search" action="<?php echo e(route('public.search')); ?>">
                    <input type="text" name="q" placeholder="<?php echo e(__('Type to search...')); ?>" class="form-control search-input" autocomplete="off">
                    <span class="close-search">&times;</span>
                </form>
                <div class="search-result"></div>
            </div>
        <?php endif; ?>
    </header>
    <div id="page-wrap">
<?php /**PATH D:\OneDrive\GOZFLY\ISPManager\ISPManager2\platform\themes/ripple/partials/header.blade.php ENDPATH**/ ?>